// Modle de gestion de stocks (texte 605).
// Question subsidaire : Optimisation de S et s (cas gnral).

// On cherche  dterminer les valeurs de S et s qui maximisent le bnfice
// moyen en rgime stationnaire avec les donnes suivantes :
// -- Les demandes mensuelles (D_n) sont i.i.d. et suivent une loi de Poisson
// de paramtre lambda=50 ;
// -- les cots sont v=30 ; c=20 ; k=1 ; C variable.

// *** On suppose qu'on a excut au moins une fois le script
// *** 0gestion-stock.sce pour que les fonctions "benef" et "matrice"
// *** soient dfinies.

// Paramtres
lambda=50;   // E(D)=50 (fixe)
v=30; c=20;  // Prix d'achat et de vente fixes (marge brute=50%)
k=1;         // cot unitaire de stockage par mois

// On fait varier le cot de livraison, par exemple : C=20, C=60, C=200.
C=200;

// On commence par maximiser le bnfice dans le cas d'un rapprovisionnement
// mensuel Bopt(1). Ensuite on essaie une solution avec rapprovisionnement 
// au bout de 2 mois Bopt(2), puis de 3 mois Bopt(3), etc. On s'arrte au 1er
// coup o Bopt(j) < Bopt(j-1).

// On calcule le bnfice moyen pour S,s,P,R,p donns
function [Bmoy]=BenefMoyen(s,S,P,BS,B0)
    // Calcul de la probabilit invariante.
    m= kernel(eye(P)-P');
    m= m' ./ sum(m);      // rsultat en ligne
    m=max(m,zeros(m));
    // Calcul du bnfice moyen en rgime stationnaire (formule 3)
    Bmoy=m(1)*BS(1)+m(2:s+1)*BS(1:s)+m(s+2:S+2)*B0(s+1:S+1);
endfunction

// Essais de diffrents couples (S,s)
function [Result,B_opt]= optim(M)
// M = 1, 2, 3, ... est le nombre de mois de stock "prvu" :
// on balaie pour S l'intervalle [M*E(D), M*E(D) + 2 * STD(D_1 + ... + D_M)]
// et pour s l'intervalle [S-(M-1)*E(D),S-M*E(D)].
S1=M*ceil(lambda);
S2=S1+2*floor(sqrt(M*lambda));
Result=zeros(S2-S1+1,3);
for S=S1:S2,
  s2=S-(M-1)*ceil(lambda);
  s1=S-M*ceil(lambda);
  // Matrice ligne des bnfices pour les valeurs de s essayes)
  B=zeros(1,ceil(lambda)+1);
  [p,R,BS,B0] = benef(S,lambda,v,c,C,k);
  [P] = matrice(s1,S,p);
  B(1)=BenefMoyen(s1,S,P,BS,B0);
  for s=s1+1:s2,
    // On incrmente s de 1 => correction de P et R (ligne s seulement !)
    P(s,:)=P(1,:);
    R(s)=R(1);
    B(1+s-s1)=BenefMoyen(s,S,P,BS,B0);
  end
  // On stocke pour chaque S le bnf max et la val. de s correspondante
  Result(1+S-S1,:)=[max(B),S,s1+max(find(B==max(B)*ones(B)))-1];
end
B_opt=max(Result(:,1));
I=min(find(Result(:,1)==B_opt*ones(Result(:,1))));
S_opt=S1+I-1;
s_opt=Result(I,3);
printf("Pour M = %d, bnfice maxi = %.2f ;\n", M, B_opt);
printf("avec S_opt = %d ; s_opt = %d ; \n", S_opt, s_opt);
endfunction

printf("\nlambda = %d ; v = %d ; c = %d ; C = %d; k = %d ;\n\n", lambda, v, c, C, k);

///////////////////////////////////////////////////////////////
// Maintenant le script de recherche des couples (S,s) optimaux
B_old=-1; B=0; M=0;
while B_old < B,
  B_old=B;
  M=M+1;
  [Result,B]=optim(M);
end

///////////////////////////////////////////////////////////////
// Rsultats
// C=20, k=1 
//   M=1  => S =  59 ; s = 56 ; B = 417.24  *** optimal
//   M=2  => S = 108 ; s = 37 ; B = 400.11
// C=60, k=1 
//   M=1  => S =  59 ; s = 56 ; B = 377.24
//   M=2  => S = 108 ; s = 37 ; B = 380.09  *** optimal
//   M=3  => S = 156 ; s = 34 ; B = 361.85
// C=200, k=1 
//   M=1  => S =  59 ; s = 56 ; B = 237.24
//   M=2  => S = 108 ; s = 37 ; B = 310.03
//   M=3  => S = 156 ; s = 34 ; B = 314.94  *** optimal
//   M=4  => S = 202 ; s = 30 ; B = 303.79
///////////////////////////////////////////////////////////////
