// Modle de gestion de stocks (texte 605).
// Question subsidaire : Optimisation de S et s (livraison tous les mois).

// On cherche  dterminer les valeurs de S et s qui maximisent le bnfice
// avec les donnes suivantes :
// -- Les demandes mensuelles (D_n) sont i.i.d. et suivent une loi de Poisson
// de paramtre lambda=50 ;
// -- les cots sont v=30 ; c=20 ; k=1 ; C variable.

// *** On suppose qu'on a excut au moins une fois le script
// *** 0gestion-stock.sce pour que les fonctions "benef" et "matrice"
// *** soient dfinies.

// Paramtres
lambda=50;   // E(D)=50 (fixe)
v=30; c=20;  // Prix d'achat et de vente fixes (marge brute=50%)
k=1;         // cot unitaire de stockage par mois

// Cas C=20.
C=20;

printf("\n  C = %d ; k = %d ;\n", C, k);

// La demande mensuelle moyenne est de 50 pices, le cot de stockage 
// de 50 pices pendant un mois est de 50, si le cot de livraison est faible
// (C=20) on n'a pas intrt  stocker pour plusieurs mois, mais plutt  se
// faire livrer tous les mois. On a aussi intrt  satisfaire la demande, 
// donc  prendre S suffisamment grand pour ne pas rater de ventes mais pas 
// trop non plus  cause des cots de stockage.
// Plage d'essais pour S : 
   S1=ceil(lambda);     // S1 =E(D)    
   S2=ceil(cdfpoi("S",lambda,0.99,0.01));// S2 : satisfaire 99% de la demande.
   s=S1;  // on recommande chaque mois.
  printf("Zone d''essais [%d, %d];\n", S1, S2);

// Vecteur colonne des bnfices (S2-S1+1 valeurs de S essayes)
B=zeros(S2-S1+1,1);
for S=S1:S2,
    [p,R,BS,B0] = benef(S,lambda,v,c,C,k);
    [P] = matrice(s,S,p);
    // Calcul de la probabilit invariante.
    m= kernel(eye(P)-P');
    m= m' ./ sum(m);      // rsultat en ligne
    m=max(m,zeros(m));
    // Calcul du bnfice moyen en rgime stationnaire (formule 3)
    B(S-S1+1)=m(1)*BS(1)+m([2:s+1])*BS([1:s])+m([s+2:S+2])*B0([s+1:S+1]);
    s=s+1;  // ainsi on a toujours S1=S2 (on recommande chaque mois)
end;
Bmax=max(B)*ones(B);
[I]=find(B==Bmax);
S_opt=S1+I-1;
// Si l'optimum est atteint  une borne de l'intervalle d'ssai [S1,S2],
// on a intrt  largir cet intervalle :
select I,
  case 1 then
  printf("Diminuer S1 : S1 = %d ; S2 = %d ; S_opt = %d ; \n", S1, S2, S_opt);
  case S2-S1+1 then
  printf("Augmenter S2 : S1 = %d ; S2 = %d ; S_opt = %d ; \n", S1, S2, S_opt);
  else
  printf("S_opt = %d ; Bnfice maxi = %.2f ;\n", S_opt, Bmax(1));
end

// Rsultat : on trouve S_opt = 59 ; Bnfice maxi = 417.24 ;
// Avec les valeurs proposes dans le texte (S=46, s=40) le bnfice 
// aurait t de 381.76 (avec une probabilit de rupture de stock de 0,68).
