// Modle de gestion de stocks (texte 605).

// Les demandes mensuelles (D_n) sont i.i.d. et suivent une loi de Poisson
// de paramtre lambda.
// Capacit maximale du stock = S (entier).
// Seuil de rapprovisionnement (bas) = s (entier). Si le niveau X_n
// du stock en fin de mois est strictement infrieur  s, on rachte 
// ce qu'il faut et le matin suivant le stock vaut S.
// X_n peut prendre les valeurs 0, 1, ... , S. On ajoute l'tat -1 qui
// correspond au cas o il y a rupture de stock.

// Paramtres
lambda=50;   // E(D)=50
v=30; c=20;  // Prix d'achat et de vente fixes (marge brute=50%)
C=20;        // cot fixe de livraison 
k=1;         // cot unitaire de stockage par mois

printf("\n  v = %d ; c = %d ; C = %d ; k = %d ;\n", v, c, C, k);
printf("  Demande moyenne mensuelle E(D) = %.2f ;\n", lambda);

// 1) Dtermination des valeurs "optimales" selon le texte :
// Choix de S :
seuil=(k+c)/v;
S=ceil(cdfpoi("S",lambda,1-seuil,seuil));
printf("  S optimal selon le texte = %d ;\n", S);
// ATTENTION : la fonction cdfpoi utilise une APPROXIMATION continue
// de la fonction de rpartition (en escalier). On devrait vrifier
// la valeur de S trouve en comparant cdfpoi("PQ",S,lambda)  1-seuil.

// Choix de s : on a besoin de p (loi de D), de R, de B0 et de BS.
// On fait une fonction qui retourne ces 4 vecteurs dont on aura
// encore besoin dans la suite.

function [p,R,BS,B0] = benef(S,lambda,v,c,C,k)
// Construction de la loi de Poisson de paramtre lambda tronque  S 
// [p_0, p_1, p_2, ... , p_S]  o  p_k = exp(-lambda) lambda^k / k!
// On pourrait aussi utiliser la fonction cdfpoi comme ceci :
// p=cdfpoi("PQ",[0:S],lambda*ones([0:S]))-[0,cdfpoi("PQ",[0:S],lambda*ones([0:S-1]))]
p=ones(1,S) ./ [1:S];// vecteur  [1, 1/2, 1/3, ... , 1/S]
p=lambda .* p;       // [lambda, lambda/2,   lambda/3,    ... lambda/S]
p=cumprod(p);        // [lambda, lambda^2/2, lambda^3/3!, ... lambda^S/S!]
p= [1, p];
p= exp(-lambda) .* p;
//
// Calcul du vecteur colonne R (fonction de survie) pour 0 <= i <= S
// R(i) = r(i) = 1 - \sum_{j=0}^{i-1} p_j
R= ones(S+1,1) - cumsum([0;p(1:S)']);
//
// Calcul du vecteur colonne BS : BS(i) = b_i(S-i) =
//    v*S*r(S) + v * \sum_{j=0}^{S-1} j*p_j - (k+c)*S - C + c*i
// pour 0 <= i <= S.
BS=(v*S*R(S+1) + v * [0:S-1] * p(1:S)' - (k+c)*S - C) * ones(S+1,1);
BS=BS + c * [0:S]';
// Vecteur colonne B0 des b_i(0) =
//    v*i*r(i) -k*i + v * \sum_{j=0}^{i-1} j*p_j
// pour 0 <= i <= S.
B0=v * [0:S]' .* R - k * [0:S]';
SumJPJ= [0,cumsum([0:S-1] .* p(1:S))];
B0=B0 + v * SumJPJ';
endfunction

// On en dduit la valeur du "s" optimal selon le texte :
// s = min {0<= i <= S | B0(i) > BS(S-i)}
[p,R,BS,B0] = benef(S,lambda,v,c,C,k);
s= min(find(B0>BS));
printf("  s optimal selon le texte = %d ;\n", s);

// Autres choix (voir optimisations)
// Dcommenter une des lignes suivantes pour comparer...
//S=59;  s=56;   // C=20; (optimal)

// Idem pour C=60 et pour C=200 :
//S=108; s=37;   // C=60;
//S=156; s=34;   // C=200;

// Pour lambda=10, C=20, on peut essayer :
//S=16; s=6;
//S=28; s=8;
//S=37; s=7;

printf("\n  On choisit S = %d ; s = %d ;\n\n", S, s);

// Pour S grand augmenter statcksize, par exemple : 
// stacksize(10^7);

// 2) X_n est une chane de Markov car
//         = X_n - D_{n+1} si { X_n >= s et X_n - D_{n+1} >= 0 }
// X_{n+1} =  S  - D_{n+1} si { X_n <  s et  S  - D_{n+1} >= 0 }
//         = -1            sinon.
// et les (D_n) sont i.i.d.

// Si on a chang la valeur de S, il faut recalculer les vecteurs p, R, B0 et BS
// qui ont chang de dimension, on rappelle donc la fonction benef.
[p,R,BS,B0] = benef(S,lambda,v,c,C,k);

// P = matrice de transition (de taille S+2 x S+2) de la chane X_n.
// On crit une fonction de manire  pouvoir le rutiliser dans la
// question subsidiaire (optimisation).
// Pour vrification de P, prendre : 
// S=7; s=3; lambda=1;
// Les lignes et colonnes sont numrotes 1 (tat -1), 2 (tat 0), 3 (tat 1), 
//  S+2 (tat S).
function [P] = matrice(s,S,p)
P=zeros(S+2,S+2);
// La colonne d'indice 1 (tat -1) se dduit des autres (somme d'une ligne =1),
// on l'ajoutera aprs. Calculons les colonnes suivantes.
// La ligne d'indice S+2 (tat S) s'obtient en retournant le vecteur 'p' :
// P(S,S-k)=p(k)
P(S+2,2:S+2)=p(S+1:-1:1);
// Les lignes d'indice 1  s+1 (tat s-1) sont identiques  la ligne S+2 :
P(1:s+1,2:S+2)=ones(s+1,1) * P(S+2,2:S+2);
// Les lignes d'indice s+2 (tat s)  S+1 (tat S-1) s'obtiennent 
// par dcalage  partir de 'p' : P(i, i-j) = p(j).
for i=s+2:S+1,
  P(i,2:i)=p(i-1:-1:1);
end
// Colonne d'indice 1 (somme d'une ligne =1) :
P(1:S+2,1)=ones(S+2,1) - sum(P,'c');
endfunction
[P] = matrice(s,S,p);

// 3) La chane est
// -- irrductible : de tout tat i on peut aller  -1 (1re col. > 0)
//    et de de -1 on peut aller  tout tat j (1re ligne > 0), donc
//    tous les tats communiquent (en 2 tapes par exemple).
// -- apriodique : la diagonale  est > 0.
// -- rcurrente positive car l'espace d'tats est fini.

// Calcul de la probabilit invariante.
// On rsout le systme linaire m P = m, ce qui revient  chercher le noyau
// de la matrice (I-P) transpose :
m= kernel(eye(P)-P');
m= m' ./ sum(m);      // rsultat en ligne
// supprimer les valeurs ngatives dues aus erreurs d'arrondi
m=max(m,zeros(m));

// Trac de la loi stationnaire du stock X(t) en fin de mois
xbasc();xselect();
Ymax=1.1*max(m);
plot2d3([0:S]',m([2:S+2])',rect=[-2,0,S+1,Ymax]);
xsegs([-1;-1],[0;m(1)],5);   // Proba de rupture de stock en rouge
xsegs([S;S],[0;Ymax],2);     // Seuil S en bleu
xsegs([s;s],[0;Ymax],3);     // Seuil s en vert

// La probabilit de tomber en rupture de stock
// en rgime stationnaire est donne par :
Prupt=m(1);
printf("Proba de rupture de stock en rg. stat. = %f\n", Prupt);
// Ceci justifi par le thorme ergodique pour les chanes de Markov.

// Calcul du bnfice moyen par priode en rgime stationnaire (formule 3).
// Ne pas oublier l'tat fictif (-1) : terme m(1) * BS(1)
Bstat= m(1) * BS(1) + m(2:s+1) * BS(1:s) + m(s+2:S+2) * B0(s+1:S+1);
printf("Bnfice estim en rgime stationnaire = %.2f\n", Bstat);

// Calcul du nombre moyen de ventes mensuelles (formule 6).
W= sum(m(1:s+1)) * (R(S+1)*S + p(2:S)*[1:S-1]');
SumJPJ= [0,cumsum([0:S-1] .* p(1:S))];
W= W + m(s+2:S+2) * ([s:S]'.* R(s+1:S+1) + SumJPJ(s:S)');
printf("Nombre moyen de ventes mensuelles en rg. stat. = %.2f\n", W);

// 4) voir les fichiers 0optimisation1.sce et 0optimisation2.sce
