// Simulation d'une file M/GI/1.
// Aux instants de dpart d'un client :
// Y_{n+1} = Y_n + 1_{Y_n>0} + K_{n+1}  o K_n est le nombre de clients
// arrivs pendant le service du n-ime client.

// Dure de la simulation (en nombre d'arrives observes).
T=10000;

// La dure de service est une v.a. D. :
// on simule d'abord un chantillon de taille T de v.a. de mme loi que D.

// 1) Dans le cas le plus simple, D est constante : 
//D=2;
//D=D * ones(T,1);
//ED=D(1);        // esprance

// 2) D uniforme sur [a,b] :
//a=1;b=3;
//D=a * ones(T,1)+ (b-a) * rand(T,1,'uniform');
//ED= (a+b)/2; // esprance

// 3) D exponentielle de paramtre a
a=1/2;
D=-log(rand(T,1,'uniform')) ./ a; 
ED= 1/a;    // esprance

// Paramtre du processus de Poisson :
// lambda = nombre moyen d'arrives par unit de temps.
lambda=0.45;   // cas stable   (rho=0.9  si ED=2)
//lambda=0.5;  // cas limite   (rho=1    si ED=2)
//lambda=0.52; // cas instable (rho=1.04 si ED=2)

// Initialisation de Y 
Y= zeros(T+1,1);
// Calcul de rho et affichage (file stable ou instable)
rho= lambda * ED;
if rho < 1 then
   printf('rho = %f < 1 : file stable.\n', rho)
else
   printf('rho = %f >= 1 : file instable.\n', rho)
 end

 // Boucle de calcul des K(n) et Y(n)
for n=1:T,
  // K(n)= nombre de clients arrivant dans un intervalle de largeur D(n),
  // K(n) suit une loi de Poisson de paramtre lambda * D(n)
  // N.B. : grand ne permet pas de prendre un paramtre vectoriel (lambda * D),
  // ce qui impose de calculer les K(n)  l'intrieur de la boucle...
  K(n)=grand(1,1,'poi', lambda * D(n));
  if Y(n)==0 then
     Y(n+1)=K(n);
  else
     Y(n+1)=Y(n) -1 + K(n);
  end
end
printf('Nombre moyen empirique de clients prsents = %f', sum(Y) ./ T)

// Affichage trajectoire (si rho>=1) ou histogramme (si rho<1).
xbasc();xselect();
if rho < 1 then
  // Si stable : histogramme (approxime le loi limite).
  Y=sort(Y); // tri de Y par ordre dcroissant
  // on limine les + grandes valeurs : celles dont la frquence cumule
  // est infrieure < 0.2%.
  h =Y(max(1,int(T / 500)));
  histplot([-1:h], Y) // la tranche [-1,0] contient la frquence de 'Y=0',
                      // voir help('histplot') : classes = ]n-1,n]
  // Trac de la loi invariante pour les services exponentiels
  // (loi gomtrique de paramtre rho) :
  pi=(1-rho) * (rho * ones([0:h])).^[0:h];
  plot2d([0:h]',pi', style=5);
else
  // Si instable : affichage de la trajectoire
  plot2d([0:T]', Y);
end

// Si rho<1, l'histogramme approche la probabilit invariante 
// (thorme ergodique des chanes de Markov).
// Vrifier dans le cas rho<1,
// -- que la frquence de 'Y=0' est proche de pi_0=(1-rho),
// -- que, dans le cas o les services  sont exponentiels la moyenne
//    empirique du nombre de clients prsents est proche de rho / (1-rho).
// Dans le cas de services exponentiels on connait la loi limite
// (gomtrique de paramtre rho), on peut la faire tracer cf. ci-dessus.
