// Comaraison des deux estimateurs pour le chantier routier.

// Simulation d'un processus de Poisson : 
// Les intervalles interarrives T_{i+1} - T_i sont indpendants
// et suivent des lois exponentielles de paramtre lambda.

// Donnes
lambda=1.1;            // paramtre
n=100;                 // nombre d'arrives  observer
// Simulation
U=rand(n,1,"uniform");
tau=-log(U) ./ lambda; // vecteur des interarrives (exp. de param. lambda)
T=cumsum(tau);         // vecteur des instants d'arrive
// Dure effective de la simulation
D=ceil(T(n));
// Estimation par les tau (calcule aux instants d'arrive)
theta1= [0:n-1]' ./ T ;
printf('Estimateur 1 (expo) = %f \n', theta1(n))
// Estimation par la fonction de comptage 
// calcule aux instants fixes 1,2,3, ... D-1)
N=sum(bool2s(T * ones(1,D-1) <= ones(T) * [1:D-1]), 'r');
theta2= N' ./ [1:D-1]';
printf('Estimateur 2 (Pois) = %f \n', theta2(D-1)); // n / T(n)
// Trac : les vecteurs  afficher n'ont pas les mmes tailles,
// il faut plusieurs 'plot2d'...
xbasc();xselect();
plot2d([T],theta1,style=[2]);
plot2d([1:D-1]',theta2,style=[13]);
xsegs([0;D],[lambda;lambda],style=[5]);
