//***************************************************
// TEXTE : MODLE MARKOVIEN d'ENDMIE
// Scopos vol 11, p. 27.
//***************************************************

// Les tats rels sont 0 (absorbant), {1,...,N-1} classe transiente,
// soit N tats, ils sont numrots en scilab de 1 (absorbant)  N.

function [P]=markov(N,p);
// Entres : N = taille de la population ; p = proba d'infecter.
// Sortie  : Matrice de la chane de Markov (NxN) tats 1 (absorbant)  N.
q=1-p;
P=zeros(N,N);
P(1,1)=1;
for i=2:N
  P(i,1:N-i+2)=binomial(1-q^(i-1),N-(i-1));
end;
endfunction;

function [ET]=espT(N,p)
// Calcul du vecteur ET, ET(i)=E_i(T) (1 <= i<= N-1), 
// dure moyenne de l'pidmie
//  partir de l'tat 'i' (i individus infects au dpart).
q=1-p;
P=markov(N,p);             // Matrice de la chane
L=P(2:N,2:N);              // On extrait la matrice des tats transients
ET=(eye(L)-L)\ones(N-1,1); // Rsolution de (I-L)T = ones(N-1,1)
endfunction

function [T]=Tsimul(N,p,i);
// La fonction Tsimul retourne le scalaire T, dure (alatoire) de l'pidmie
// avec 'i' individus infects au dpart.
t=0;
j=i;
P=markov(N,p);;
while j>0,             
  t=t+1;                    
  // Calcul de l'tat suivant par pseudo-inverse pour
  // la loi donne par la ligne j+1 de A=P.
  // N.B. : cette mthode s'applique  toute matrice markovienne,
  //  condition de l'avoir construite (pas toujours facile...)
  u=rand(1,'uniform');      
  V=cumsum(P(j+1,:));
  j=min(find(V>=u))-1;
  // Une autre mthode consisterait  simuler la binomiale
  // comme somme de Bernoulli...
  // N.B. : comme la loi de transition est facilement simulable (binomiale),
  // on peut viter la construction de la matrice de transition.
  // U=rand(N-j,1,'uniform');
  // j=sum(bool2s(U<1-q^j));
end;
T=t; 
endfunction;

function histogramme(N,p,i)
// Retourne la moyenne empirique et l'cart type empirique de K=100
// valeurs de T (dure de l'pidmie) et trace l'histogramme pour
// comparaison  la valeur de ET.
// Valeur calcule de l'esprance.
ET=espT(N,p);
ETi=ET(i);
// Simulations :
K=100;
T=zeros(1,K); // vecteur ligne pour xsegs
for k=1:K
  T(k)=Tsimul(N,p,i)
end;
Moy=sum(T)/K;
Ecart=sqrt(sum((T - Moy * ones(T)).^2) /(K-1));
printf('\n');
printf(' Esprance de T       = %f\n', ETi);
printf(' Moyenne empirique    = %f\n', Moy);
printf(' Ecart-type empirique = %f\n', Ecart);
// Reprsentation graphique
xbasc();
xselect();
subplot(2,1,1)
// Affichage de l'esprance calcule en bleu (style=2) et en fixant
// un cadre adapt au diagramme (rect=...)
plot2d([0:K]', ETi*ones(K+1,1), style=2, rect=[0,0,K,ceil(max(T))]);
// Affichage du diagramme (en rouge = 5)
xsegs([1:K;1:K], [zeros(T);T], 5);
// Histogramme des valeurs de T et valeur de ETi (en bleu)
subplot(2,1,2)
histplot([1:1:max(T)+1],T)
xsegs([ETi;ETi], [0;1], style=2)
endfunction;

// tude de la suite rcurrente dterministe
function graphe(N,p)
// Trac du graphe de la fonction y = g(x) = (1-x) (1-exp(-Ax))
// o A = -N ln q et de la 1re bissectrice. 
// On affiche le point fixe I et la valeur de A.
q=1-p;
A=-N * log(q);
X=[0:0.01:1]';  // 100 points sur l'axe Ox
Y=(ones(X)-X) .* (ones(X) - exp(-A *X));
// Trac en utilisant plot2d.
// N.B. : on pourrait aussi utliser 'deff' et 'fplot2d'.
xbasc();
xselect();
plot2d(X,[X,Y]);
// Calcul du point fixe par 'fsolve' si A > 1
if A > 1 then
  deff('y=h(x)', 'y=(1-x)*(1-exp(-A*x))-x');
  I=fsolve(0.5,h);
  printf('A=%f > 1. Point fixe : I=%f',A,I);
else
  printf('A=%f <= 1. Point fixe I=0',A);
end;
endfunction;

////////////////////////////////////////////////////////////////////
// Autre construction de la matrice de la chane :
// Triangle de Pascal pour les C_n^p, matrice des (1-q^i)^j,
// matrice des q^i(N-i-j).
// La mthode utilisant la fonction 'binomial' est beaucoup
// plus simple, les carts maxi sont < 10^{-15} jusqu' N=100,
// le vrifier en faisant max(abs(markov(N,p)-markov1(N,p))),
// la fonction 'binomial' semble donc fiable...
function [C]=pascal(N)
// Calcul de la matrice des coefficients binomiaux par triangle de Pascal,
// lignes 1  N. ATTENTION : C_n^k = C(n,k+1) (0 <= k <= n <= N).
C=zeros(N,N+1);
C(1:N,1)=1;// Colonne 1
C(1,2)=1 ; // Ligne 1 = [1 1]
for n=2:N  // Lignes suivantes
  C(n,1:n+1)=C(n-1,1:n+1)+[0 C(n-1,1:n)];
end;
endfunction;

function [P]=markov1(N,p);
// Matrice de la chane de Markov : tats 1 (absorbant)  N.
q=1-p;
m1=ones(1,N);
m2=ones(N,1);
q1=m2-(q.^(0:N-1)'); // fabrication du vecteur colonne (1-q^i)
q1=q1*m1;            // on rplique N fois le vecteur -> matrice NxN
a=m2*(0:N-1);        // matrice des puissances
q2=q1.^a;            // matrice des (1-q^i)^j
b=(0:N-1)'*m1;
n=N*ones(b);
c=max(zeros(n),n-b-a);
q3=q.^(b.*c);        // matrice des q^i(N-i-j)
C=pascal(N-1);
Q=C(N-1:-1:1,:);     // on inverse les lignes de la matrice
Q=[1 zeros(1,N-1);Q] // on ajoute la 1re ligne [1 0 0 ... 0]
P=Q.*q2.*q3;
endfunction
//////////////////////////////////////////////////////////////////

