//*********************************************
// ESTIMATION DE DURES DE VIE CENSURES
// Texte Scopos vol 11, p. 181-186.
//*********************************************

// Estimation de dures de vie censures suivant une loi de Weibull,
// On choisit de prendre tous les instants de censure gaux.

/////////////////// Paramtres ///////////////////////////////////
ETA=100; // paramtres de la loi de Weibull
BETA=2;  // N.B.: pas beta qui dsigne la fonction eulrienne classique !
// N.B. : la mdiane  vaut  ETA * (ln 2)^{1/BETA}
//        l'esprance vaut  ETA * Gamma(1 + 1/BETA)
c=40;    // seuil de censure
n=25;    // taille d'un chantillon
N=50;    // nombre d'chantillons
// Affichage des donnes :
printf('\nDonnes : BETA = %.1f, ETA = %.0f (c=%d, n=%d, N=%d).\n',BETA,ETA,c,n,N)
//////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////
// Gnration d'un chantillon de taille n d'une loi de Weibull
// de paramtres ETA=100, BETA donn (compris entre 0.5 et 3).
// La fonction de rpartition tant continue strictement croissante,
// le calcul de la fonction de rpartition inverse est immdiat :
// Si U suit une loi uniforme sur [0,1], 
// W = ETA (-ln U)^{1/BETA} suit la loi Weibull(ETA,BETA).
rand('uniform');
U=rand(N,n);
W=ETA .* (-log(U)) .^(1/BETA);
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
///  Initialisation : fabrication des chantillons censurs     ///
// Matrice de mme taille que W, M(i,j)=1 si W(i,j)<=c, et 0 sinon.
M=(bool2s(W<=c));
m=sum(M,'c');// Nombre d'observations non censures de chaque chantillon
// Affichage du pourcentage global (tous chantillons confondus)
// d'observations censures.
printf('Pourcentage d''observations censurees : %.2f\n', 1-sum(m)/N/n);
///////////            Raffinement (optionnel)             ////////////
// La mthode MV choue si l'chantillon n'a que des observations > c...
// On supprime donc les chantillons dont toutes les observations sont > c
// (et on rduit N en consquence).
// On construit un vecteur colonne TC dont chaque ligne contient 1 si
// l'chantillon correspondant est totalement censur...
TC=bool2s(m==zeros(m));
// ... puis un vecteur colonne V contenant les indices des lignes
// totalement censures...
j=1; V=[];
for i=1:N,
  if TC(i)==1 then, V(j)=i; j=j+1;  end 
end
// enfin on supprime les lignes correspondantes de W, M et m
// (cf. poly d'introduction  Scilab p. 16)...
W(V,:)=[]; M(V,:)=[]; m(V,:)=[];
// et on redimensionne N et U :
if sum(TC)==N then,
  printf('Aucun echantillon valide : arret !!!\n\n')
  abort
else,
  printf('%d echantillon(s) supprime(s) sur %d.\n\n',sum(TC),N);
  N=N-sum(TC);
  U=zeros(W); 
end
///////////           Fin du  raffinement              ////////////
// On remplace dans W les valeurs > c par c :
WT=min(W,c .* ones(W));
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
///         Estimation par le maximum de vraisemblance          ///
// Soit fn0(x) la fonction dont on cherche une racine (beta),
// l'expression de fn0 est donne p. 182 (avant-dernire ligne).
// La fonction fn0(x) et x sont des *vecteurs* colonnes  N composantes,
// ainsi on traite en une seule fois les N chantillons.
// On reporte dans la seconde quation la valeur de beta trouve
// et on obtient ainsi l'estimation de eta.
x=ones(m);
L=ones(1,n);
// N.B. : l'expression 'y=...' qui dfinit la fonction marche, 
// mais pas dans la fonction... a semble d aux quotes des arguments 'c' des 
// fonctions sum(...).
// deff("y=fn0(x)","y = m ./ x + sum(log(W) .* M,'c')  - m .* sum((WT .^ (x*L)) .* log(WT),'c') ./ sum(WT .^ (x*L),'c')");
// Palliatif : dfinir col='c' et remplacer 'c' par col (sans quotes).
col='c';
deff("y=fn0(x)","y = m ./ x + sum(log(W) .* M,col)  - m .* sum((WT .^ (x*L)) .* log(WT),col) ./ sum(WT .^ (x*L),col)");
B0=ones(m); // On initialise tous les beta  1.
// B=valeur approche de la racine beta pour chaque chantillon (vecteur) :
B=fsolve(B0,fn0); 
// E=valeur approche du eta correspondant pour chaque chantillon (vecteur) :
E= (sum(WT .^ (B*L),'c') ./ m) .^ (1 ./B);
// Affichage des rsultats (mthode MV) avec 2 dcimales :
// estimateur et cart-type empirique entre parenthses.
MB=sum(B)/N; ME=sum(E)/N;
if N==1 then,
  TB=0; TE=0;
else,
  TB=sqrt(sum((B - MB .* ones(B)).^2)/(N-1));
  TE=sqrt(sum((E - ME .* ones(E)).^2)/(N-1));
end
printf('Estimation MV     : BETA = %.2f (%.2f), ETA = %.2f (%.1f)\n\n',MB,TB,ME,TE)\n
/// Arrt (si on ne veut que l'estimation MV).
//abort
//////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////
////////////           Mthode SEM                ////////////////
//////////// Boucle : nombre fixe I d'itrations  ////////////////
I=5;
//
// On introduit un boolen pour pouvoir choisir entre
// -- une estimation chantillon par chantillon des paramtres 
//    BETA et ETA utiliss pour simuler les donnes manquantes,
// -- une estimation de BETA et ETA prenant en compte globalement
//    les N chantillons.
GLOBAL=%f;  // essayer  %t et %f
//
// Pour tester la validit de l'algorithme, on peut tricher : 
// on peut initialiser B et E  B=BETA et E=ETA (les vraies valeurs !)
// B=BETA*ones(m); MB=BETA;
// E=ETA*ones(m);  ME=ETA;
// et vrifier que la 1re estimation SEM(1) est bonne...
//
for i=1:I,
//////////// Phase 1 : simulation des donnes manquantes /////////
// La fonction de rpartition tant encore continue strictement croissante,
// le calcul de la fonction de rpartition inverse est immdiat :
// Si U suit une loi uniforme sur [0,1], 
// Y = ETA ( (c/ETA)^BETA - ln U )^{1/BETA} suit la loi Weibull(ETA,BETA)
// conditionne par Y>c.
// Pour simuler les donnes manquantes, on choisit comme valeurs initiales
// de ETA et BETA les estimateurs obtenus par la mthode MV.
U=rand(U); // nouveau tirage de loi uniforme sur [0,1]
// Pour allger la formule WS, on introduit des matices K et INVB
if GLOBAL then,                           // estimation globale
  K= (c/ME)^MB .* ones(U);
  INVB=ones(U) ./ MB;
  WS= ME*ones(U) .* (K - log(U)) .^ INVB; // chantillon simul
else,                                     // estimation par chantillon
  K= ((c .* ones(U)) ./ (E*L)) .^ (B*L);
  INVB=ones(U) ./ (B*L);
  WS=(E*L) .* (K - log(U)) .^ INVB;       // chantillon simul
end
// Nouvel chantillon  complt  :
WS=bool2s(W>c) .* WS + M .* W;
//////////// Phase 2 : estimation par M.V. ///////////////////////
// Soit fn1(x) la fonction dont on cherche une racine.
// Cette fois, il n'y a plus de donnes censures (on les a simules),
// fn1 se dduit de fn0 en remplaant 'm' par 'n' (vecteur colonne).
// Comme dans fn0 : remplacer 'c' par col...
deff('y=fn1(x)','y = (n .* ones(m)) ./ x + sum(log(WS),col)  - (n .* ones(m)) .* sum((WS .^ (x*L)) .* log(WS),col) ./ sum(WS .^ (x*L),col)')
// valeur approche de la racine beta pour chaque chantillon (vecteur) :
// B0=B;           // on part de l'estimation MV 
B0=MB * ones(m);   // on part de la moyenne des estimations MV 
B=fsolve(B0,fn1); 
// valeur approche du eta correspondant pour chaque chantillon (vecteur) :
E= (sum(WS .^ (B*L),'c') ./ (n .* ones(m))) .^ (1 ./B);
// Affichage des rsultats (mthode SEM) avec 2 dcimales  chaque itration
MB=sum(B)/N; ME=sum(E)/N; 
if N==1 then,
  TB=0; TE=0;
else,
  TB=sqrt(sum((B - MB .* ones(B)).^2)/(N-1)); 
  TE=sqrt(sum((E - ME .* ones(E)).^2)/(N-1));
end
printf('Estimation SEM(%d) : BETA = %.2f (%.2f), ETA = %.2f (%.1f)\n',i,MB,TB,ME,TE)
end // fin boucle 'for'
//////////////////////////////////////////////////////////////////

///  FAIRE : 
/// -- comparer les estimations SEM dans les 2 cas global=%t et global=%f
///    conclusion ?
/// -- essayer N=1 avec n=250 (un seul grand chantillon)..
/// -- essayer d'autres valeurs de BETA (0.5, 1, 3).
