//*********************************************
// LE COUSSIN FINANCIER
// Texte Scopos vol 16, p. 233.
//*********************************************

//////// Convergence du modle discret vers le modle continu ////////

// Augmenter stacksize autant que possible :
stacksize(20000000);  // valeur standard = 5000000

//Donnes (celles du texte)
mu=0.1;
r=0.05;
v=0.2;
S0=1;
V0=100;
P0=90;
m=5;
C0=V0-P0;

// nombre de tranches dans [0,1]
n=500; 
// nombre de trajectoires  simuler pour l'histogramme du coussin discret
N=5000; 

// Densit de C1 (loi lognormale : formule 9)
sigma2=v^2*m^2;              // variance de la loi normale sous-jacente
moy=m*(mu-r)+r - sigma2/2;   // moyenne  de la loi normale sous-jacente
// chelle sur Ox : E(LogNorm) = exp(moy+sigma2 /2), xmax= 20 * E(LogNorm)
xmax=ceil(20*exp(moy+sigma2 /2));
pas=xmax/100;
x=[1:pas:xmax]';
g=exp(-(log(x./C0)-moy).^2 ./ sigma2 ./2) ./ (sqrt(2*%pi*sigma2) .* x);

// Simulation de N trajectoires Cnk
U=rand(N,n,'uniform');
Z=(-1+2*bool2s(U<0.5*ones(U))) /sqrt(n);
Y=(mu/n)*ones(U)+ v*Z;
C1=C0 * prod(ones(U) + m*Y + ((1-m)*r/n)*ones(U), 'c');

// Trac de l'histogramme et de la loi limite
xbasc();
xselect();
plot2d([0;x],[0;g],style=5,rect=[0,0,xmax,2*max(g)]);
histplot([0:xmax],C1,style=2,frameflag=0);
