//*********************************************
// MODLISATION DU SYSTME ALOHA
// Texte Scopos vol 16, p. 145.
//*********************************************

/////////////////////////////////////////////////////////////////////
///////////////   Modle  nombre infini d'metteurs   //////////////
/////////////////////////////////////////////////////////////////////

function [b]=accr(p,alpha,nmax) 
// Calcul de b(n) = E(N(t+1)-N(t) | N(t)=n) :
// b(n) = alpha - exp(-alpha) (1-p)^(n-1) ((1-p)alpha +np)
// entre n=0 et n=nmax et trac de la courbe.
//
N=[0:nmax]';              // vecteur colonne
b=alpha * ones(N);        // vecteur colonne
b=b - exp(-alpha) .* (1-p)^N .* ((1-p)*alpha + p *(N+ones(N)));
endfunction

// Trac de la courbe b(n)
function trace_b(p,alpha,nmax) 
// L'intersection de la courbe avec la droite y=0 donne
// les deux points critiques n0 et nc. 
b=accr(p,alpha,nmax);
xbasc();       // Effacer la fentre graphique,
xselect();     // et la faire passer au premier plan.
plot2d([0:nmax]',b);
// droite y=0
xsegs([0;nmax],[0;0],style=5);
endfunction

// Calcul des points critiques n0 et nc ( la main).
// On pourrait utiliser la fonction 'fsolve' pour rsoudre b(n)=0 mais 
// comme on recherche des ENTIERS c'est inutile...
function [nc,n0]=critique(p,alpha,nmax)
// La fonction retourne les valeurs entires par excs de n0 et nc.
b=accr(p,alpha,nmax);
x=find(b<0);
if x==[],
  printf('b est toujours positive !\n');
  n0=0; nc=0;
else  
  // Attention : les indices vont de 1  nmax+1, les valeurs de 0  nmax
  n0=min(find(b<=0))-1;
  nc=max(x);
end;
endfunction
//

/////////////////////////////////////////////////////////////////////
// Mthode  analytique pour le calcul du temps moyen avant explosion
// dans le modle infini.
// On agglomre tous les tats > nc en un seul not nc+1 ; ce nouvel
// tat est rendu absorbant.
// Soit T_n le temps mis par le systme pour passer de l'tat n  
// l'tat nc+1 et m-n=E(T_n) son esprance. Il est facile d'obtenir
// un systme linaire d'quations en (m_n) en considrant ce qui
// se passe entre l'instant 0 et l'instant 1 (analogue  l'exo sur
// le temps moyen d'atteinte des tats rcurrents) :
//    E(T_i) = \sum_{j=0}^M  [1 + E(T_j | N(1)=j)] * P(i,j)   d'o
//    m_i = 1 + \sum_{j=0}^M  m_j * P(i,j)     pour  0 <= i <= nc
// et m_i = 0 si i= nc+1.
//
function [M,nc]=duree(p,alpha)
// Calcul de nc :
[nc,n0]=critique(p,alpha,100);
///// Calcul de la matrice P ////
P=zeros(nc+2,nc+2); // tats "dcals" : 1, 2, ... , nc+2 (et pas 0, 1, nc+1)
// Calcul de la sous-diagonale de P (sauf dernire ligne et dernire colonne)
I=[1:nc];
D=p .*I .* (1-p)^(I-ones(I)) .* exp(-alpha);
P(1:nc+1,1:nc+1)=P(1:nc+1,1:nc+1)+diag(D,-1);
// Calcul de la diagonale de P (sauf ...)
I=[0:nc];
D=(1-p)^I .* alpha .* exp(-alpha);
D=D+ (ones(I)-I .* p .* (1-p)^(I-ones(I))) .* exp(-alpha);
P(1:nc+1,1:nc+1)=P(1:nc+1,1:nc+1)+diag(D,0);
// Calcul de la sur-diagonale de P (sauf ...)
I=[0:nc-1];
D= alpha .* exp(-alpha) .* (1-(1-p)^I);
P(1:nc+1,1:nc+1)=P(1:nc+1,1:nc+1)+diag(D,1);
// Calcul des autres diagonales (j > i+1) (sauf ...)
// On pose k= j-i (numro de la sur-diagonale); on a nc-j = nc-i-k
for k = 2:nc,
  D= (alpha^k ./ prod(1:k) .* exp(-alpha)) * ones(nc+1-k,1);
  P(1:nc+1,1:nc+1)=P(1:nc+1,1:nc+1)+diag(D,k);
end;
// Calcul de la dernire colonne (nc+2) (pas ncessaire pour la rsolution) :
P(:,nc+2) = ones(nc+2,1) - sum(P,'col')
///// Fin du calcul de la matrice P ////
//
// On rsout le systme (I-P) m = (1).
U=ones(nc+1,1);
P=P(1:nc+1,1:nc+1);
I=eye(P);
m=(I-P) \ U;
M=m(n0);
endfunction

// Essayer cette fonction :
// duree(.095,.36) ->  temps moyen =     286 avec nc=10.
// duree(.049,.33) ->  temps moyen =    4254 avec nc=25.
// duree(.049,.30) ->  temps moyen =   50744 avec nc=30.
// duree(.049,.27) ->  temps moyen = 1823802 avec nc=35.
//

/////////////////////////////////////////////////////////////////////
// Simulation dans le modle limite  nombre infini de canaux.
//
// On simule une trajectoire de X(n), nombre de canaux bloqus  l'instant n.
// Soit N_n la v.a. nombre de nouveaux appels entre n et n+1,
// N_n suit une loi de Poisson de paramtre alpha.
// Soit R_n la v.a  nombre d'appels rmis entre n et n+1 (par les bloqus),
// R_n suit une loi binomiale B(p,X(n)).
// L'volution de X entre les instants n et n+1 est donne par :
// X(n+1) = X(n) - 1 si  N_n=0 et R_n=1
//        = X(n)     si (N_n=1 et R_n=0) ou (N_n=0 et R_n<>1)
//        = X(n) + 1 si  N_n=1 et R_n>=1
//        = X(n) + k si  N_n=k >=2

function simul(p,alpha,nmax)
X=zeros(nmax+1,1);
// On part par exemple du point fixe stable n0.
[nc,n0]=critique(p,alpha,100);
X(1)=n0;
rand('uniform');
// Tirage d'un chantillon de v.a. de Poisson de param. alpha, de taille nmax.
N=grand(nmax,1,'poi',alpha);
for n=1:nmax,
  // Tirage de R suivant une loi binomiale B(p,X(n)) (somme de v.a. Bernoulli).
  if X(n)==0, 
    R=0;
  else
    R=sum(bool2s(rand(1,X(n))<p));
  // ... ou bien en utilisant la fonction 'grand' de scilab :
  // R=grand(1,1,'bin',X(n),p);
  end
  // Calcul de X(n+1).
  if (N(n)==0) & (R==1),
    X(n+1) = X(n)-1;
  elseif (N(n)==1) & (R>=1),
    X(n+1) = X(n) + 1;
  elseif N(n)>=2,
    X(n+1) = X(n) + N(n);
  else
    X(n+1) = X(n); // Cas (N=0 et R<>1) ou (N=1 et R=0)
  end
end;
// Graphe de la trajectoire
xbasc();       // Effacer la fentre graphique,
xselect();     // et la faire passer au premier plan.
// trac de la trajectoire et des droites y=nc et y=n0 par plot2d :
//plot2d([0:nmax]',[X,n0*ones(X),nc*ones(X)],style=[2,5,13]);
// ou plus conomique (faire tracer les droites par xsegs) :
// trajectoire en bleu, cadre suffisant pour tracer X et la droite y=nc
plot2d([0:nmax]',X,style=2,rect=[0,0,nmax,max(nc+1,max(X))]);
xsegs([0;nmax],[nc;nc],style=5);  // droite y=nc (en rouge)
xsegs([0;nmax],[n0;n0],style=13); // droite y=n0 (en vert)
endfunction

// Faire plusieurs essais de
// simul(.05,.3,10000)
//

/////////////////////////////////////////////////////////////////////
///////////////   Modle  nombre fini d'metteurs   ////////////////
/////////////////////////////////////////////////////////////////////

function [P]=matBIN(p,sigma,M)
// Calcule de la matrice markovienne du modle fini de taille M,
// sigma = proba d'mission d'un nouveau paquet,
// p = proba de r-mettre un paquet bloqu.
// NB : vrifier sur qq exemples, avec sum(P,'col'), que la matrice
//      est bien stochastique.
// Application : calculer la proba invariante et vrifier qu'elle
// charge fortement les valeurs proches de M.
//
P=zeros(M+1,M+1);
// Calcul de la sous-diagonale de P
I=[1:M];
D=p .*I .* (1-p)^(I-ones(I)) .* (1-sigma)^(M*ones(I)-I)
P=P+diag(D,-1);
// Calcul de la diagonale de P
I=[0:M];
D=(1-p)^I .* (M*ones(I)-I) .* sigma .* (1-sigma)^((M-1)*ones(I)-I);
D=D+ (ones(I)-I .* p .* (1-p)^(I-ones(I))) .* (1-sigma)^(M*ones(I)-I);
P=P+diag(D,0);
// Calcul de la sur-diagonale de P
I=[0:M-1];
D=(M*ones(I)-I) .* sigma .* (1-sigma)^((M-1)*ones(I)-I) .* (1-(1-p)^I);
P=P+diag(D,1);
// Calcul des autres diagonales (j > i+1)
// Matrice des coefficients binomiaux (triangle de Pascal)
C=zeros(M,M);
C(1:M,1)=[1:M]';
C(2,2)=1;
for l = 2:M-1,
    C(l+1,2:l+1)=C(l,2:l+1)+[C(l,1:l)];
end;
// On pose k= j-i (numro de la sur-diagonale); on a M-j = M-i-k
for k = 2:M,
  I=[0:M-k];
  // on a besoin de la colonne k de la matrice des coefficients binomiaux
  // mais dans l'ordre inverse : C(k:M,k) -> C(M:-1:k,k).
  D=C(M:-1:k,k)' .* sigma^k .* (1-sigma)^(M*ones(I)-I-k*ones(I));
  P=P+diag(D,k);
end;
endfunction

function [m]=probainv(p,sigma,M)
// Calcul et affichage de la proba invariante
// Calcul de P :
P=matBIN(p,sigma,M);
// Rsolution de m(I-P+A)=mA=(1,1,...,1) avec A=ones(P)
m=ones(1,M+1)/(eye(P)-P+ones(P));
// Affichage
xbasc();       // Effacer la fentre graphique,
xselect();     // et la faire passer au premier plan.
plot2d([0:M]',m');
// Vrifier la concentration de la masse de m autour de M
// pour diffrentes valeurs de p et sigma.

