%%
%% This is file `logbook.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% logbook.dtx  (with options: `cls')
%% 
%% IMPORTANT NOTICE:
%% 
%% For the copyright see the source file.
%% 
%% Any modified versions of this file must be renamed
%% with new filenames distinct from logbook.cls.
%% 
%% For distribution of the original source see the terms
%% for copying and modification in the file logbook.dtx.
%% 
%% This generated file may be distributed as long as the
%% original source files, as listed above, are part of the
%% same distribution. (The sources need not necessarily be
%% in the same archive or directory.)
\NeedsTeXFormat{LaTeX2e}[2005/12/01]
\ProvidesFile{logbook.cls}
             [2019/08/14 v3.3b (Daniel Flipo)]
\newif\ifPrivate
\newif\ifSorted
\DeclareOption{private}
   {\Privatetrue}
\DeclareOption{public}
   {\Privatefalse}
\DeclareOption{sorted}
   {\Sortedtrue\def\diveinc{1}}
\DeclareOption{latestlast}
   {\Sortedtrue\def\diveinc{1}}
\DeclareOption{latestfirst}
   {\Sortedfalse\def\diveinc{-1}}
\DeclareOption{french}{%
  \def\dllanguage{french}%
  \def\dltitle{{Carnet de plong\'ee}}%
  \def\dldivenr{{Plong\'ee \no}}%
  \def\dldate{{Date :}}%
  \def\dlarea{{R\'egion :}}%
  \def\dlspot{{Site :}}%
  \def\dlGPS{{GPS :}}%
  \def\dlNorth{{N}}%
  \def\dlSouth{{S}}%
  \def\dlWest{{O}}%
  \def\dlEast{{E}}%
  \def\dlbuddy{{Bin\^ome :}}%
  \def\dlmaxdepth{{Prof. max. :}}%
  \def\dlduration{{Dur\'ee :}}%
  \def\dltime{{Heure :}}%
  \def\dltimestart{{de }}%
  \def\dltimeend  {{ \`a }}%
  \def\dltimeclose{}%
  \def\dlsurfint{{Int. surface :}}%
  \def\dlcompdata{{Ordinateur}}%
  \def\dlcdmodel{{Mod\`ele :}}%
  \def\dlcdserial{{\No }}%
  \def\dlcdpersonal{{Utilisateur :}}%
  \def\dlcdmode{{R\'eglages :}}%
  \def\dlprofil{{Profil de plong\'ee}}%
  \def\dlgasdata{{M\'elange}}%
  \def\dltankvol{{Volume bloc :}}%
  \def\dllitres{{litres}}%
  \def\dlbars{{bar}}%
  \def\dlpstart{{Pression initiale :}}%
  \def\dlpend{{Pression finale :}}%
  \def\dlpressures{{Pressions :}}%
  \def\dlvolused{{Conso (litres) :}}%
  \def\dlnotes{{Notes}}%
  \def\dlwatertemp{{Temp. eau :}}%
  \def\dlavgdepth{{Prof. moyenne :}}%
  \def\dlsac{{Conso surface :}}%
  \def\dlccr{{Recycleur :}}%
  \def\dlsetpoints{{Set Points :}}%
  \def\dldiluent{{Diluant :}}%
  \def\dloxygen{{Oxyg\`ene}}%
  \def\dldiluentvol{{Conso diluant :}}%
  \def\dloxygenvol{{Conso oxyg\`ene :}}%
  \def\dlmaxcns{{CNS }}%
  \def\dlotu{{OTU :}}%
  \def\dlVMAX{{Remont\'ee max. :}}%
  \def\dlmaxtts{{TTR max :}}%
  \def\dldesat{{D\'esaturation :}}%
  \def\dlAIR{{Air}}%
  \def\dlOXY{{O$_2$}}%
}
\DeclareOption{english}{%
  \def\dllanguage{english}%
  \def\dltitle{{Diver's log}}%
  \def\dldivenr{{Dive\#:}}%
  \def\dldate{{Date:}}%
  \def\dlarea{{Area:}}%
  \def\dlspot{{Spot:}}%
  \def\dlGPS{{GPS:}}%
  \def\dlNorth{{N}}%
  \def\dlSouth{{S}}%
  \def\dlWest{{W}}%
  \def\dlEast{{E}}%
  \def\dlbuddy{{Buddy:}}%
  \def\dlmaxdepth{{Max.\ depth:}}%
  \def\dlduration{{Dive time:}}%
  \def\dltime{{Time:}}%
  \def\dltimestart{{(}}%
  \def\dltimeend  {{\ to }}%
  \def\dltimeclose{{)}}%
  \def\dlsurfint{{Surf.\ interval:}}%
  \def\dlcompdata{{Computer data:}}%
  \def\dlcdmodel{{Model:}}%
  \def\dlcdserial{{Serial\#:}}%
  \def\dlcdpersonal{{Userinfo:}}%
  \def\dlcdmode{{Mode/Adj.:}}%
  \def\dlprofil{{Dive profile:}}%
  \def\dlgasdata{{Gas}}%
  \def\dltankvol{{Cylinder volume:}}%
  \def\dllitres{{litres}}%
  \def\dlbars{{bars}}%
  \def\dlpstart{{Initial pressure:}}%
  \def\dlpend{{Final pressure:}}%
  \def\dlpressures{{Pressures:}}%
  \def\dlvolused{{Volume used:}}%
  \def\dlnotes{{Notes:}}%
  \def\dlwatertemp{{Temperature:}}%
  \def\dlavgdepth{{Average depth:}}%
  \def\dlsac{{SAC:}}%
  \def\dlccr{{Rebreather:}}%
  \def\dlsetpoints{{Set Points:}}%
  \def\dldiluent{{Diluent:}}%
  \def\dloxygen{{Oxygen}}%
  \def\dldiluentvol{{Diluent used:}}%
  \def\dloxygenvol{{Oxygen used:}}%
  \def\dlmaxcns{{CNS}}%
  \def\dlotu{{OTU:}}%
  \def\dlVMAX{{Max. Ascent:}}%
  \def\dlmaxtts{{TTS max:}}%
  \def\dldesat{{Full desat:}}%
  \def\dlAIR{{Air}}%
  \def\dlOXY{{O$_2$}}%
}
\DeclareOption{german}{%
  \def\dllanguage{german}%
  \def\dltitle{{Logbuch}}%
  \def\dldivenr{{TG Nr.:}}%
  \def\dldate{{Datum:}}%
  \def\dlarea{{Tauchgebiet:}}%
  \def\dlspot{{Tauchplatz:}}%
  \def\dlGPS{{GPS:}}%
  \def\dlNorth{{N}}%
  \def\dlSouth{{S}}%
  \def\dlWest{{W}}%
  \def\dlEast{{O}}%
  \def\dlbuddy{{Tauchpartner:}}%
  \def\dlmaxdepth{{Max.\ Tiefe:}}%
  \def\dlduration{{Tauchzeit:}}%
  \def\dltime{{Uhrzeit:}}%
  \def\dltimestart{{von }}%
  \def\dltimeend  {{\ bis }}%
  \def\dltimeclose{{}}%
  \def\dlsurfint{{Ofl.\ Pause:}}%
  \def\dlcompdata{{Computerdaten:}}%
  \def\dlcdmodel{{Modell:}}%
  \def\dlcdserial{{SerienNr.:}}%
  \def\dlcdpersonal{{Benutzerinfo:}}%
  \def\dlcdmode{{Einstellungen:}}%
  \def\dlprofil{{Tauchgangsprofil:}}%
  \def\dlgasdata{{Atemgas}}%
  \def\dltankvol{{Flasche:}}%
  \def\dllitres{{Liter}}%
  \def\dlbars{{bar}}%
  \def\dlpstart{{Startdruck:}}%
  \def\dlpend{{Enddruck:}}%
  \def\dlpressures{{Dr\"ucke:}}%
  \def\dlvolused{{Gas verbraucht:}}%
  \def\dlnotes{{Bemerkungen:}}%
  \def\dlwatertemp{{Temperatur:}}%
  \def\dlavgdepth{{Durchschnitt T.:}}%
  \def\dlsac{{SAC:}}%
  \def\dlccr{{Rebreather:}}%
  \def\dlsetpoints{{Set Points:}}%
  \def\dldiluentname{{Diluent:}}%
  \def\dloxygen{{Sauerstoff}}%
  \def\dldiluentvol{{Diluent verbraucht:}}%
  \def\dloxygenvol{{Sauerstoff verbraucht:}}%
  \def\dlmaxcns{{CNS}}%
  \def\dlotu{{OTU:}}%
  \def\dlVMAX{{Max Ascent:}}%
  \def\dlmaxtts{{TTS max:}}%
  \def\dldesat{{Voll Ents\"attigung:}}%
  \def\dlAIR{{Luft}}%
  \def\dlOXY{{Sauerstoff}}%
}
\ExecuteOptions{latestfirst,private,french}
\ProcessOptions\relax
\LoadClass[a5paper]{article}
\RequirePackage[paper=a5paper,width=105mm,height=175mm,
                marginratio=1:1]{geometry}
\RequirePackage[T1]{fontenc}
\RequirePackage{lmodern}
\RequirePackage{textcomp}
\RequirePackage{microtype}
\RequirePackage{verbatim}
\RequirePackage{pgf,tikz}
\usetikzlibrary{shapes.misc,calc,babel}
\RequirePackage[\dllanguage]{babel}
\setlength\parindent{0mm}
\setlength\parskip{0.5\baselineskip}
\newlength\graphheight
\setlength{\graphheight}{.25\textheight}
\newlength\GFheight
\setlength{\GFheight}{.12\textheight}
\definecolor{Acolor}{rgb}{1,0.5,0.0}
\definecolor{Bcolor}{rgb}{0,0,1}
\definecolor{Ccolor}{rgb}{0.75,0.5,0.25}
\definecolor{Dcolor}{rgb}{0.75,0.5,0.25}
\definecolor{Ecolor}{rgb}{1,0.0,0.0}
\definecolor{Fcolor}{rgb}{1,0.0,0.0}
\definecolor{Ucolor}{rgb}{0.5,0.0,0.5}
\definecolor{Tcolor}{rgb}{0.75,0.5,0.25}
\definecolor{Path1}{rgb}{0.0,0.0,1.0}
\definecolor{Path2}{rgb}{0.0,0.3,0.0}
\definecolor{Path3}{rgb}{0,0,0}
\definecolor{Path4}{rgb}{0.45,0.3,0.15}
\definecolor{Path5}{rgb}{0.4,0,0.3}
\definecolor{Path6}{rgb}{1,0.0,0.0}
\definecolor{Path7}{rgb}{1,0.0,0.0}
\definecolor{Path8}{rgb}{1,0.0,0.0}
\newcommand*{\SPlowStyle}{LBdashed}
\newcommand*{\SPhighStyle}{solid}
\newcommand*{\SPmedStyle}{densely dashed}
\newcommand*{\BOStyle}{LBdotted}
\newcommand*{\TimeDepthFont}{\scriptsize}
\newcommand*{\AlarmFont}{\bfseries\scriptsize}
\newcommand*{\SwitchFont}{\bfseries\scriptsize}
\newcommand*{\UserTagFont}{\bfseries\scriptsize}
\newcommand*{\TTSFont}{\bfseries\scriptsize}
\newcommand*{\GFFont}{\bfseries\scriptsize}
\newlength\AlarmFontHeight
\newlength\SwitchFontHeight
\newlength\GasNameTagsWidth
\newlength\BoxWidth
\newcount\dive@count
\newcount\gas@count
\newcount\gas@switch
\newcount\sp@count
\newcount\sp@switch
\newcount\alarm@count
\newcount\ceiling@count
\newcount\oxy@duration
\newcount\tags@count
\newcount\n
\newif\ifCCRmode
\newif\ifBO
\newif\ifNeverBO
\newif\ifPlotGF  \PlotGFtrue
\def\Units#1{\gdef\cdunits{#1}}            \def\cdunits{}
\def\Vendor#1{\gdef\cdvendor{#1}}          \def\cdvendor{}
\def\Model#1{\gdef\cdmodel{#1}}            \def\cdmodel{}
\def\Version#1{\gdef\cdversion{#1}}        \def\cdversion{}
\def\Serialid#1{\gdef\cdserial{#1}}        \def\cdserial{}
\def\Persinfo#1{\gdef\cdpersinfo{#1}}      \def\cdpersinfo{}
\def\Totaldives#1{\def\cdtotaldives{#1}}   \def\cdtotaldives{}
\def\DiveNr#1{\def\tmp{#1}%
  \ifx\tmp\@empty
    \global\advance\dive@count by \diveinc
  \else
    \global\dive@count= #1
  \fi
  \ifnum\dive@count<1
    \ClassWarning{logbook.cls}{%
        Undefined Dive Nr!\MessageBreak
        Enter your LAST dive number\MessageBreak
        in the 1st command \protect\DiveNr\MessageBreak}%
    \def\divenr{???}%
  \else
    \def\divenr{\number\dive@count}%
  \fi
}
\def\divenr{}
\def\Area#1{\def\tmp{#1}%
  \ifx\tmp\@empty\else\gdef\divearea{#1}\fi
 }
\def\divearea{}
\def\Spot#1{\def\divespot{#1}}
\def\divespot{}
\def\GPS#1#2{\def\divelat{#1}\def\divelong{#2}}
\def\divelat{}\def\divelong{}
\def\Buddy#1{\def\tmp{#1}%
  \ifx\tmp\@empty\else\gdef\divebuddy{#1}\fi}
\def\divebuddy{}
\def\DiveDate#1#2#3{\def\divedate{#3/#2/#1}} \def\divedate{}
\def\TimeStart#1#2{\def\timestart{#1:#2}}    \def\timestart{}
\def\TimeEnd#1#2{\def\timeend{#1:#2}}        \def\timeend{}
\def\SurfInt#1#2{\def\tmpa{#1}\def\tmpb{#2}%
                 \ifx\tmpb\@empty\def\surfint{#1}%
                 \else\ifx\tmpa\@empty\def\surfint{#2 \minabbrev}%
                      \else\def\surfint{#1\hourabbrev #2}%
                      \fi
                 \fi}
\def\hourabbrev{:}  \def\minabbrev{min}  \def\surfint{}  \def\gfsep{/}
\def\WaterTempMin#1{\def\watertempmin{#1}}\def\watertempmin{}
\def\WaterTempMax#1{\def\watertempmax{#1}}\def\watertempmax{}
\def\WaterTempAvg#1{\def\watertempavg{#1}}\def\watertempavg{}
\def\Density#1{\def\density{#1}}         \def\density{}
\def\AirPressure#1{\def\airpressure{#1}} \def\airpressure{}
\let\Altitude\AirPressure
\def\DeltaT#1{\def\cddelta{#1}}          \def\cddelta{1}
\def\TProfile#1{\def\tprofile{#1}}       \def\tprofile{}
\def\Profile#1{\def\dprofile{#1}}        \def\dprofile{}
\def\SPlist#1{\def\splist{#1}}           \def\splist{}
\def\GASswitches#1{\def\gswitches{#1}}   \def\gswitches{}
\let\Switches\GASswitches
\def\GASlist#1{\def\gaslist{#1}}         \def\gaslist{}
\def\Alarms#1{\def\cdalarms{#1}}         \def\cdalarms{}
\def\Ascent#1{}
\def\VmaxAscent#1{\def\VMascent{#1}}     \def\VMascent{}
\def\Ceiling#1{\def\cdceiling{#1}}       \def\cdceiling{}
\def\LastTic#1{\def\lasttic{#1}}         \def\lasttic{}
\def\Duration#1{\def\duration{#1}}       \def\duration{}
\def\MaxDepth#1{\def\maxdivedepth{#1}}   \def\maxdivedepth{}
\def\AvgDepth#1{\def\avgdivedepth{#1}}   \def\avgdivedepth{}
\def\DecoMode#1{\def\decomode{#1}}       \def\decomode{}
\def\GFprofile#1{\def\gfprofile{#1}}     \def\gfprofile{}
\def\GFlo#1{\def\gflow{#1}}              \def\gflow{}
\def\GFhi#1{\def\gfhigh{#1}}             \def\gfhigh{}
\def\GFstep#1{\def\gfstep{#1}}           \def\gfstep{}
\def\MaxCNS#1{\def\maxcns{#1}}           \def\maxcns{}
\def\OTUday#1{\def\otu{#1}}              \def\otu{}
\def\MaxTTS#1{\def\maxtts{#1}}           \def\maxtts{}
\def\MaxTTSdepth#1{\def\maxttsdepth{#1}} \def\maxttsdepth{}
\def\MaxTTStime#1{\def\maxttstime{#1}}   \def\maxttstime{}
\def\DecoStops#1{\def\decostops{#1}}     \def\decostops{}
\def\Desat#1#2{\def\desat{#1\hourabbrev #2}} \def\desat{}
\def\CCRname#1{\def\ccrname{#1}}         \def\ccrname{}
\def\getfirst@LIST#1 #2\endparse{\xdef\tmp{#1}\xdef\LIST{#2\space}}
\def\getfirsttwo@LIST#1 #2 #3\endparse{\xdef\tmp{(#1,-#2)}%
                                       \xdef\LIST{#3\space}}
\def\getfirst@LISTB#1 #2\endparse{\xdef\tmp{#1}\xdef\LISTB{#2\space}}
\def\getfirst@LISTC#1 #2\endparse{\xdef\tmp{#1}\xdef\LISTC{#2\space}}
\def\getfirst@tags#1\relax #2\endparse{\def\tmp{#1}%
                                      \xdef\LIST{#2}}
\newcommand*{\Gas}[3]{\def\tmp{#2}%
   \expandafter\edef\csname gasname\romannumeral#1\endcsname{\tmp}%
   \expandafter\edef\csname gasfactor\romannumeral#1\endcsname{#3}%
   \advance\gas@count by 1
}
\newcommand*{\PstartGas}[2]{\def\tmp{#2}%
  \ifx\tmp\@empty
    \expandafter\def\csname pstart\romannumeral#1\endcsname{}%
  \else
    \expandafter\edef\csname pstart\romannumeral#1\endcsname{#2}%
  \fi}
\newcommand*{\PendGas}[2]{\def\tmp{#2}%
  \ifx\tmp\@empty
    \expandafter\def\csname pend\romannumeral#1\endcsname{0}%
  \else
    \expandafter\edef\csname pend\romannumeral#1\endcsname{#2}%
  \fi}
\def\TankVolDefault{12}
\def\TankVolGas#1#2{\def\tmp{#2}%
  \ifx\tmp\@empty
    \expandafter\ifx\csname tankvol\romannumeral#1\endcsname\relax
       \expandafter\xdef\csname tankvol\romannumeral#1\endcsname
         {\TankVolDefault}%
    \fi
  \else
    \expandafter\xdef\csname tankvol\romannumeral#1\endcsname{#2}%
  \fi}
\newcommand*{\volusedgas}[1]{%
      \edef\tmp{\csname tankvol\romannumeral#1\endcsname}%
      \edef\tmpb{\csname pstart\romannumeral#1\endcsname}%
      \edef\tmpc{\csname   pend\romannumeral#1\endcsname}%
      \pgfmathparse{round(\tmp * (\tmpb - \tmpc))}%
      \xdef\@volusedgas{\pgfmathresult}%
      \pgfmathprintnumber{\pgfmathresult}%
}
\newcommand*{\SAC}[1]{%
      \edef\tmp{\csname gasfactor\romannumeral#1\endcsname}%
      \pgfmathparse{\@volusedgas / \tmp}%
      \pgfmathprintnumber{\pgfmathresult}%
}
\newcommand*{\Diluent}[2][1]{\def\tmp{#2}%
   \expandafter\edef\csname gasname\romannumeral#1\endcsname{\tmp}%
   \advance\gas@count by 1
}
\def\TankVolCCRDiluentDefault{3.0}
\newcommand*{\TankVolDiluent}[2][1]{\def\tmp{#2}%
  \ifx\tmp\@empty
    \expandafter\ifx\csname tankvol\romannumeral#1\endcsname\relax
       \expandafter\xdef\csname tankvol\romannumeral#1\endcsname
         {\TankVolCCRDiluentDefault}%
    \fi
  \else
    \expandafter\xdef\csname tankvol\romannumeral#1\endcsname{#2}%
  \fi}
\newcommand*{\PstartDiluent}[2][1]{\def\tmp{#2}%
  \ifx\tmp\@empty
    \expandafter\def\csname pstart\romannumeral#1\endcsname{}%
  \else
    \expandafter\edef\csname pstart\romannumeral#1\endcsname{#2}%
  \fi}
\newcommand*{\PendDiluent}[2][1]{\def\tmp{#2}%
  \ifx\tmp\@empty
    \expandafter\def\csname pend\romannumeral#1\endcsname{0}%
  \else
    \expandafter\edef\csname pend\romannumeral#1\endcsname{#2}%
  \fi}
\def\diluent@nr{i}
\newcommand*{\MainDiluentNR}[1]{%
   \ifnum\gas@count>1 \edef\diluent@nr{\romannumeral #1}\fi
}
\def\diluent{\expandafter\csname gasname\diluent@nr\endcsname}%
\def\tankvoldil{\expandafter\csname tankvol\diluent@nr\endcsname}%
\def\pstartdil{\expandafter\csname pstart\diluent@nr\endcsname}%
\def\penddil{\expandafter\csname pend\diluent@nr\endcsname}%
\def\TankVolCCROxygenDefault{3.0}
\newcommand*{\TankVolOxygen}[1]{\def\tmp{#1}%
  \ifx\tmp\@empty
    \ifx\tankvoloxygen\@undefined
       \xdef\tankvoloxygen{\TankVolCCROxygenDefault}%
    \fi
  \else
    \xdef\tankvoloxygen{#1}%
  \fi}
\newcommand*{\PstartOxygen}[1]{\def\tmp{#1}%
  \ifx\tmp\@empty \def \pstartoxygen{}%
  \else           \edef\pstartoxygen{#1}%
  \fi}
\newcommand*{\PendOxygen}[1]{\def\tmp{#1}%
  \ifx\tmp\@empty \def \pendoxygen{0}%
  \else           \edef\pendoxygen{#1}%
  \fi}
\newcommand*{\Bailout}[2][1]{\def\tmp{#2}%
}
\newcommand*{\TankVolBailout}[2][1]{\def\tmp{#2}%
  \ifx\tmp\@empty
    \expandafter\ifx\csname tankvol\romannumeral#1\endcsname\relax
       \expandafter\xdef\csname tankvolbailout\romannumeral#1\endcsname
         {\TankVolDefault}%
    \fi
  \else
    \expandafter\xdef\csname tankvolbailout\romannumeral#1\endcsname{#2}%
  \fi}
\newcommand*{\PstartBailout}[2][1]{\def\tmp{#2}%
  \ifx\tmp\@empty
    \expandafter\def\csname pstartbailout\romannumeral#1\endcsname{}%
  \else
    \expandafter\edef\csname pstartbailout\romannumeral#1\endcsname{#2}%
  \fi}
\newcommand*{\PendBailout}[2][1]{\def\tmp{#2}%
  \ifx\tmp\@empty
    \expandafter\def\csname pendbailout\romannumeral#1\endcsname{0}%
  \else
    \expandafter\edef\csname pendbailout\romannumeral#1\endcsname{#2}%
  \fi}
\newcommand*{\diluentused}{%
  \pgfmathparse{%
    round(\tankvoldil * (\pstartdil - \penddil))}%
  \pgfmathprintnumber{\pgfmathresult}%
}
\newcommand*{\oxygenused}{%
  \pgfmathparse{\tankvoloxygen * (\pstartoxygen - \pendoxygen)
                       / (\oxy@duration * \cddelta / 60)}%
  \pgfmathprintnumber{\pgfmathresult}%
}
\newcommand*{\GetGasSwitches}{%
  \ifx\gswitches\@empty
  \else
    \BOfalse
    \ifx\splist\@empty\CCRmodefalse\else\CCRmodetrue\fi
    \ifCCRmode
       \oxy@duration=\lasttic
       \MakeSetpointsList
    \fi
    \edef\LIST{\gswitches\space}%
    \expandafter\getfirst@LIST\LIST\endparse
    \gas@switch=\tmp
    \expandafter\getfirst@LIST\LIST\endparse
    \edef\pathattr{\Pstyle/\Pcolor}%
    \edef\PstyleOld{\Pstyle}%
    \ifCCRmode
       \edef\PcolorCC{\Pcolor}%
    \else
       \edef\PcolorOld{\Pcolor}%
    \fi
    \expandafter\getfirst@LIST\LIST\endparse
    \edef\switchtics{\tmp\space}%
    \ifnum\gas@switch>1
      \foreach \k in {2,...,\gas@switch}{%
        \expandafter\getfirst@LIST\LIST\endparse
        \expandafter\getfirst@LIST\LIST\endparse
        \let\tmpb\tmp
        \expandafter\getfirst@LIST\LIST\endparse
        \let\tmpc\tmp
        \ChangePathAttributes{\tmpb}{\tmpc}%
        \xdef\pathattr{\pathattr,\Pstyle/\Pcolor}%
        \xdef\switchtics{\switchtics\tmpc\space}%
       }%
    \fi
    \ifBO\advance\oxy@duration by -\lasttic\fi
  \fi
}
\def\BOtag{BO}
\def\SPtag{SP}
\def\StripPendingEqual#1={#1}
\def\SplitName#1=#2\endparse{\edef\@suffix{#2}%
\ifx\@suffix\@empty
   \let\@prefix\@empty\edef\@suffix{#1}%
\else
   \edef\@prefix{#1}%
   \edef\@suffix{\expandafter\StripPendingEqual\@suffix}%
\fi}
\def\Pcolor{Path1}%
\def\Pstyle{solid}%
\def\PstyleOld{\Pstyle}%
\def\PcolorOld{\Pcolor}%
\newcommand*{\ChangePathAttributes}[2]{%
    \expandafter\SplitName#1=\endparse
    \ifx\@prefix\@empty
       \xdef\Pcolor{\PcolorOld}%
       \xdef\Pstyle{\PstyleOld}%
       \ChangePathColor{\@suffix}%
       \ifCCRmode
         \ifBO
           \xdef\PcolorOld{\Pcolor}%
         \else
           \xdef\PcolorCC{\Pcolor}%
         \fi
       \else
         \xdef\PcolorOld{\Pcolor}%
       \fi
       \xdef\PstyleOld{\Pstyle}%
       \ifBO\global\advance\oxy@duration by -#2\fi
       \global\BOfalse
    \fi
    \ifx\@prefix\SPtag
       \xdef\Pcolor{\PcolorCC}%
       \xdef\Pstyle{\PstyleOld}%
       \ChangePathStyle{\@suffix}%
       \xdef\PstyleOld{\Pstyle}%
       \xdef\PcolorOld{\Pcolor}%
       \ifBO\global\advance\oxy@duration by -#2\fi
       \global\BOfalse
    \fi
    \ifx\@prefix\BOtag
       \xdef\Pstyle{\BOStyle}%
       \ifBO
       \else
          \global\advance\oxy@duration by #2
          \xdef\PcolorCC{\Pcolor}%
       \fi
       \ChangePathColor{\@suffix}%
       \ifNeverBO\xdef\BOcolor{\Pcolor}\fi
       \global\BOtrue
       \global\NeverBOfalse
    \fi
}
\def\StripBraces#1#2\endparse{\ifx#2\@empty #1\else #1#2\fi}
\newcommand*{\ChangePathColor}[1]{%
   \edef\tmpa{\expandafter\StripBraces#1\endparse}%
   \edef\LISTB{\gaslist\space}%
   \expandafter\getfirst@LISTB\LISTB\endparse
   \@tempcnta=\tmp
   \foreach \k in {1,...,\@tempcnta} {%
       \expandafter\getfirst@LISTB\LISTB\endparse
       \xdef\tmp{\expandafter\StripBraces\tmp\endparse}%
       \global\n=\k
       \ifx\tmp\tmpa \breakforeach\fi
     }
     \xdef\Pcolor{Path\number\n}%
}
\newcommand*{\ChangePathStyle}[1]{%
   \edef\tmpa{#1}%
   \edef\LISTB{\splist\space}%
   \expandafter\getfirst@LISTB\LISTB\endparse
   \@tempcnta=\tmp
   \ifcase\@tempcnta
      \or % 1 SP value
        \xdef\Pstyle{\SPhighStyle}%
      \or % 2 SP values
        \expandafter\getfirst@LISTB\LISTB\endparse
        \ifx\tmp\tmpa
           \xdef\Pstyle{\SPlowStyle}%
        \else
           \xdef\Pstyle{\SPhighStyle}%
        \fi
      \or % 3 SP values
        \expandafter\getfirst@LISTB\LISTB\endparse
        \ifx\tmp\tmpa
           \xdef\Pstyle{\SPlowStyle}%
        \else
          \expandafter\getfirst@LISTB\LISTB\endparse
          \ifx\tmp\tmpa
             \xdef\Pstyle{\SPmedStyle}%
          \else
             \xdef\Pstyle{\SPhighStyle}%
          \fi
        \fi
      \fi
}
\newcommand*{\MakeSetpointsList}{%
   \edef\LISTB{\splist\space}%
   \expandafter\getfirst@LISTB\LISTB\endparse
   \@tempcnta=\tmp
   \foreach \k in {1,...,\@tempcnta} {%
      \expandafter\getfirst@LISTB\LISTB\endparse
      \ifnum\k=1
        \xdef\setpointslist{\tmp}%
      \else
        \ifx\tmp\BOtag
        \else
          \xdef\setpointslist{\setpointslist\space/\space\tmp}%
        \fi
      \fi
     }%
}
\iflanguage{german}{%
   \pgfkeys{/pgf/number format/.cd,
            fixed,
            precision=1,
            set decimal separator={.},
            set thousands separator={,}
           }
}{}
\iflanguage{english}{%
   \pgfkeys{/pgf/number format/.cd,
            fixed,
            precision=1,
            set decimal separator={.},
            set thousands separator={,}
           }
}{}
\iflanguage{french}{%
   \pgfkeys{/pgf/number format/.cd,
            fixed,
            precision=1,
            set decimal separator={,},
            set thousands separator={\,}
           }
}{}
\newenvironment{nodive}[1][]
  {\def\nodive@title{#1}%
   \ifx\nodive@title\@empty
   \else
     \bgroup\centering\textbf{\Large \nodive@title}\egroup\par
     \vspace{\baselineskip}%
   \fi}
  {\clearpage}
\newenvironment{dive}
  {\gas@count=0 \sp@count=0
   \def\gaslist{}%
   \def\splist{}%
   \def\gswitches{}%
   \def\Pstyle{solid}%
   \def\Pcolor{Path1}%
   \NeverBOtrue
  }
  {\clearpage}
\newcommand{\PrintData}{%
  \ifx\gfprofile\@empty\PlotGFfalse\fi
  \PrintSiteData \par
  \GetGasSwitches
  \PrintComputerData
  \mbox{}\par\vspace{-\baselineskip}%
  \ifx\dprofile\@empty\else\PrintGraph\fi \par
  \ifPlotGF\PrintGF\par\fi
}
\newcommand{\PrintSiteData}{%
  \makebox[.5\textwidth][l]{\large\textbf{\dldivenr\ \divenr}}%
  \makebox[.5\textwidth][r]{\large\textbf{\dldate\ \divedate}}%
  \par
  \makebox[.25\textwidth][l]{\textbf{\dlarea}}%
  \makebox[.75\textwidth][l]{\textbf{\divearea}}%
  \newline
    \makebox[.25\textwidth][l]{\textbf{\dlspot}}%
    \makebox[.75\textwidth][l]{\textbf{\divespot}%
             \ifx\divelat\@empty
             \else
               \quad(\dlGPS\ \divelat\quad\divelong)%
             \fi
            }%
  \newline
  \makebox[.25\textwidth][l]{\textbf{\dlbuddy}}%
  \makebox[.75\textwidth][l]{\textbf{\divebuddy}}%
}
\newcommand{\PrintComputerData}{%
  \makebox[.25\textwidth][l]{\textbf{\dlcompdata}}%
  \makebox[.25\textwidth][l]{%
     \cdmodel\ifx\cdversion\@empty\else\space(\cdversion)\fi}%
  \makebox[.25\textwidth][l]{\dlcdserial\space\cdserial}%
  \makebox[.25\textwidth][l]{%
     \ifx\gflow\@empty \decomode
     \else             \decomode\space(\gflow\gfsep\gfhigh)
     \fi}%
  \newline
  \makebox[.25\textwidth][l]{\dlsurfint}%
  \makebox[.25\textwidth][l]{\surfint}%
  \makebox[.25\textwidth][l]{\dlwatertemp}%
  \makebox[.25\textwidth][l]{%
     \ifx\watertempmin\@empty
     \else
       \pgfmathprintnumber{\watertempmin}%
       \ifx \watertempmax\@empty
         \textdegree C
       \else
         \textendash\pgfmathprintnumber{\watertempmax}\textdegree C
         \ifx\watertempavg\@empty
         \else (\pgfmathprintnumber{\watertempavg}\textdegree C)%
         \fi
       \fi
     \fi}%
  \newline
  \makebox[.25\textwidth][l]{\dlduration}%
  \makebox[.25\textwidth][l]{\duration\ \minabbrev}%
  \makebox[.25\textwidth][l]{\dltime}%
  \makebox[.25\textwidth][l]{\dltimestart\timestart
                             \dltimeend\timeend\dltimeclose}%
  \newline
  \makebox[.25\textwidth][l]{\dlmaxdepth}%
  \makebox[.25\textwidth][l]{%
      \ifx\maxdivedepth\@empty
      \else
        \pgfmathprintnumber{\maxdivedepth} m%
      \fi}%
  \makebox[.25\textwidth][l]{\dlavgdepth}%
  \makebox[.25\textwidth][l]{%
      \ifx\avgdivedepth\@empty
      \else
        \pgfmathprintnumber{\avgdivedepth} m%
      \fi}%
  \ifx\desat\@empty
    \ifx\otu\@empty
      \ifx\maxcns\@empty
        \ifx\VMascent\@empty
        \else
          \newline
          \makebox[.25\textwidth][l]{\dlVMAX}%
          \makebox[.25\textwidth][l]{%
            \pgfmathprintnumber{\VMascent} m/min}%
        \fi
      \else
        \newline
        \makebox[.25\textwidth][l]{\dlmaxcns :}%
        \makebox[.25\textwidth][l]{\maxcns\ \%}%
        \ifx\VMascent\@empty
        \else
          \makebox[.25\textwidth][l]{\dlVMAX}%
          \makebox[.25\textwidth][l]{%
            \pgfmathprintnumber{\VMascent} m/min}%
        \fi
      \fi
    \else
       \newline
       \ifx\maxcns\@empty
         \makebox[.25\textwidth][l]{\dlmaxcns\ / \dlotu}%
         \makebox[.25\textwidth][l]{\textemdash\ / \otu}%
         \ifx\VMascent\@empty
         \else
           \makebox[.25\textwidth][l]{\dlVMAX}%
           \makebox[.25\textwidth][l]{%
             \pgfmathprintnumber{\VMascent} m/min}%
         \fi
       \else
         \makebox[.25\textwidth][l]{\dlmaxcns\ / \dlotu}%
         \makebox[.25\textwidth][l]{\maxcns\ \% / \otu}%
         \ifx\VMascent\@empty
         \else
           \makebox[.25\textwidth][l]{\dlVMAX}%
           \makebox[.25\textwidth][l]{%
             \pgfmathprintnumber{\VMascent} m/min}%
         \fi
       \fi
    \fi
  \else
    \newline
    \makebox[.25\textwidth][l]{\dldesat}%
    \makebox[.25\textwidth][l]{\desat}%
    \ifx\otu\@empty
      \ifx\maxcns\@empty
        \ifx\VMascent\@empty
          \makebox[.25\textwidth][l]{\dlmaxcns :}%
          \makebox[.25\textwidth][l]{\textemdash}%
        \else
          \makebox[.25\textwidth][l]{\dlVMAX}%
          \makebox[.25\textwidth][l]{%
            \pgfmathprintnumber{\VMascent} m/min}%
        \fi
      \else
        \makebox[.25\textwidth][l]{\dlmaxcns :}%
        \makebox[.25\textwidth][l]{\maxcns\ \%}%
      \fi
    \else
       \ifx\maxcns\@empty
         \makebox[.25\textwidth][l]{\dlmaxcns\ / \dlotu}%
         \makebox[.25\textwidth][l]{\textemdash\ / \otu}%
       \else
         \makebox[.25\textwidth][l]{\dlmaxcns\ / \dlotu}%
         \makebox[.25\textwidth][l]{\maxcns\ \% / \otu}%
      \fi
    \fi
  \fi
  \ifx\decostops\@empty
  \else
    \newline
    \makebox[.25\textwidth][l]{\dlmaxtts}%
    \makebox[.25\textwidth][l]{\maxtts\ \minabbrev}%
    \parbox[t]{.5\textwidth}{\raggedright
      \settowidth{\BoxWidth}{00@00m}%
      \edef\LIST{\decostops\space}%
      \expandafter\getfirst@LIST\LIST\endparse
      \edef\tmpa{\tmp}
      \foreach \k in {1,...,\tmpa}{%
         \expandafter\getfirst@LIST\LIST\endparse
         \makebox[\BoxWidth][r]{\tmp}\space
        }
    }%
  \fi
  \ifCCRmode
     \par
     \makebox[.25\textwidth][l]{\textbf{\dlccr}}%
     \makebox[.25\textwidth][l]{\textbf{\ccrname}}%
     \makebox[.25\textwidth][l]{\dlsetpoints}%
     \makebox[.25\textwidth][l]{\setpointslist}%
     \newline
     \makebox[.25\textwidth][l]{\textbf{\dloxygen}}%
     \makebox[.25\textwidth][l]{%
        (\pgfmathprintnumber{\tankvoloxygen}\ \dllitres)}%
     \makebox[.25\textwidth][l]{\textbf{\dldiluent}}%
     \makebox[.25\textwidth][l]{\textbf{\diluent}\ %
        (\pgfmathprintnumber{\tankvoldil}\ \dllitres)}%
     \newline
     \ifx\pstartoxygen\@empty
     \else
       \makebox[.25\textwidth][l]{\dlpressures}%
       \makebox[.25\textwidth][l]{\pstartoxygen\space
                      \textendash\space\pendoxygen\space\dlbars}%
       \makebox[.25\textwidth][l]{\dlpressures}%
       \makebox[.25\textwidth][l]{\pstartdil\space
                      \textendash\space\penddil\space\dlbars}%
       \newline
       \makebox[.25\textwidth][l]{\dloxygenvol}%
       \makebox[.25\textwidth][l]{\oxygenused\ l/\minabbrev}%
       \makebox[.25\textwidth][l]{\dldiluentvol}%
       \makebox[.25\textwidth][l]{\diluentused\ \dllitres}%
       \newline
     \fi
  \else
    \n=0
    \par
    \loop\ifnum\n<\gas@count
      \advance\n by 1
      \makebox[.25\textwidth][l]{\textbf{\dlgasdata
          \ifnum\gas@count>1\ \number\n\fi}}%
      \makebox[.25\textwidth][l]{\textbf{%
           \csname gasname\romannumeral\n\endcsname}}%
      \makebox[.25\textwidth][l]{\dltankvol}%
      \makebox[.25\textwidth][l]{%
        \edef\tmp{\csname tankvol\romannumeral\n\endcsname}%
        \ifx\tmp\@empty\else\pgfmathprintnumber{\tmp} \dllitres\fi}%
    \newline
      \expandafter\ifx\csname pstart\romannumeral\n\endcsname\@empty
        \mbox{}%
      \else
        \makebox[.25\textwidth][l]{\dlpstart}%
        \makebox[.25\textwidth][l]{%
          \edef\tmp{\csname pstart\romannumeral\n\endcsname}%
          \ifx\tmp\@empty\else\pgfmathprintnumber{\tmp} \dlbars\fi}%
        \makebox[.25\textwidth][l]{\dlpend}%
        \makebox[.25\textwidth][l]{%
          \edef\tmp{\csname pend\romannumeral\n\endcsname}%
          \ifx\tmp\@empty\else\pgfmathprintnumber{\tmp} \dlbars\fi}%
        \newline
        \makebox[.25\textwidth][l]{\dlvolused}%
        \makebox[.25\textwidth][l]{\volusedgas\n\ \dllitres}%
        \makebox[.25\textwidth][l]{\dlsac}%
        \makebox[.25\textwidth][l]{\SAC\n\ l/\minabbrev}%
        \newline
      \fi
    \repeat
  \fi
}
\newcommand*{\graph@setup}{%
  \pgfmathparse{(\linewidth)/\lasttic}%
  \edef\Xunit{\pgfmathresult}%
  \pgfmathparse{ceil(\maxdivedepth)}%
  \edef\Ymax{\pgfmathresult}%
  \pgfmathparse{\Ymax>10 ? 2 : 1}%
  \edef\Ytic{\pgfmathresult}%
  \pgfmathparse{\Ymax>20 ? 5 : \Ytic}%
  \edef\Ytic{\pgfmathresult}%
  \pgfmathparse{\Ymax>80 ? 10 : \Ytic}%
  \edef\Ytic{\pgfmathresult}%
  \pgfmathparse{ceil(\Ymax/\Ytic)*\Ytic}%
  \edef\Ymax{\pgfmathresult}%
  \pgfmathparse{\graphheight/\Ymax}%
  \edef\Yunit{\pgfmathresult}%
  \settoheight{\AlarmFontHeight}{\AlarmFont X}%
  \pgfmathparse{2*\AlarmFontHeight/\graphheight*\Ymax}%
  \edef\Yalarm{\pgfmathresult}%
    \settoheight{\SwitchFontHeight}{\SwitchFont X}%
    \pgfmathparse{1.5*\SwitchFontHeight/\graphheight*\Ymax}%
    \edef\Ystep{\pgfmathresult}%
    \pgfmathparse{\Ymax - 0.5*\Ystep}%
    \edef\Ygs{\pgfmathresult}%
    \settowidth{\GasNameTagsWidth}{\SwitchFont 0TX00/00}%
    \pgfmathparse{\GasNameTagsWidth/\linewidth*\lasttic)}%
    \edef\SPwd{\pgfmathresult}%
    \pgfmathparse{\lasttic-\SPwd}%
    \edef\SPposX{\pgfmathresult}%
  \pgfmathparse{\duration>20 ? int(300/\cddelta) : int(60/\cddelta)}%
  \edef\Xtic{\pgfmathresult}%
  \pgfmathparse{\duration>120 ? int(600/\cddelta) : \Xtic}%
  \edef\Xtic{\pgfmathresult}%
  \pgfmathparse{60 / \cddelta}%
  \edef\Xscale{\pgfmathresult}%
}
\newcommand*{\ASCENT}{ASCENT}
\newcommand*{\ERROR}{ERROR}
\newcommand*{\DECO}{DECO}
\newcommand*{\DEEPSTOP}{DEEP_STOP_MISSED}
\newcommand*{\CEILING}{DECO_CEILING_PASSED}
\newcommand*{\PPOHIGH}{PPO2_HIGH}
\newcommand*{\PPOLOW}{PPO2_LOW}
\newcommand*{\BOOKMARK}{BOOKMARK}
\newcommand*{\BATTERY}{LOW_BATTERY}
\newcommand*{\user@tags}{}
\newcommand*{\UserTag}[3]{%
  \edef\tmpa{#1}%
  \pgfmathparse{\tmpa * 60 / \cddelta}%
  \edef\tmpa{\pgfmathresult}%
  \edef\tmpb{#2}%
  \edef\tmp{#3}%
  \ifx\tmp\@empty\else
    \advance\tags@count by 1
    \edef\user@tags{\user@tags\space\tmpa\space\tmpb\space\tmp\relax}%
  \fi
}
\newcommand*{\print@user@tags}{%
  \ifnum\tags@count>0
    \edef\LIST{\user@tags\space}%
    \expandafter\getfirst@LIST\LIST\endparse
     \foreach \k in {1,...,\tags@count}{%
        \expandafter\getfirsttwo@LIST\LIST\endparse
        \let\tmpa\tmp
        \expandafter\getfirst@tags\LIST\endparse
        \node at \tmpa [color=Ucolor] {+};
        \node[below right]  at \tmpa [color=Ucolor] {\UserTagFont\tmp};
        \expandafter\getfirst@LIST\LIST\endparse
       }%
  \fi
}
\newcommand*{\PrintGraph}{\graph@setup
  \textbf{\dlprofil}\newline
  \centerline{\hss
  \begin{tikzpicture}[x=\Xunit,y=\Yunit]
     \tikzstyle{LBdashed}=[dash pattern=on 2.5pt off 1pt];
     \tikzstyle{LBdotted}=[line width=1pt, dash pattern=on
                           \pgflinewidth off 1.5pt];
    \ifx\cdceiling\@empty\else
      \edef\LIST{\cdceiling\space}
      \expandafter\getfirst@LIST\LIST\endparse
      \ceiling@count=\tmp
      \let\tmpa\@empty
      \foreach \k in {1,...,\ceiling@count} {%
         \expandafter\getfirsttwo@LIST\LIST\endparse
         \xdef\tmpa{\tmpa\space\tmp}
        }
      \filldraw[thick,draw=Ccolor,fill=Ccolor!50]
                            plot coordinates{\tmpa};
    \fi
    \draw[gray,thick] (0,-\Ymax) rectangle (\lasttic,0);
    \draw[gray] (0,-\Ymax) grid[xstep=\Xtic,ystep=\Ytic] (\lasttic,0);
    \pgfmathparse{int(2*\Ytic)}
    \edef\Yii{\pgfmathresult}
    \ifnum\Yii>\Ymax
      \node at (0,-\Ytic) [left] {\TimeDepthFont\Ytic};
      \node at (\lasttic,-\Ytic) [right] {\TimeDepthFont\Ytic};
    \else
      \foreach \y in {\Ytic,\Yii,...,\Ymax}
        {\node at (0,-\y) [left] {\TimeDepthFont\y};
         \node at (\lasttic,-\y) [right] {\TimeDepthFont\y};
        }
    \fi
    \pgfmathparse{int(2*\Xtic)}
    \xdef\Xii{\pgfmathresult}
    \ifnum\Xii>\lasttic
       \pgfmathparse{int(\Xtic / \Xscale)}
       \edef\Xinc{\pgfmathresult}
       \node at (\Xtic,0) [above] {\TimeDepthFont \Xinc};
    \else
      \foreach \x in {\Xtic,\Xii,...,\lasttic}
        {\pgfmathparse{int(\x / \Xscale)}
         \edef\Xinc{\pgfmathresult}
         \node at (\x,0) [above] {\TimeDepthFont \Xinc};
        }
    \fi
    \draw[gray] (\lasttic,0) -- (\lasttic,-\Ymax);
    \edef\LIST{\dprofile\space}
    \edef\LISTB{\switchtics\lasttic\space}
    \expandafter\getfirst@LISTB\LISTB\endparse
    \n=\tmp
    \ifx\tprofile\@empty \else
      \edef\LISTC{\tprofile\space}
    \fi
    \foreach \s / \c in \pathattr {%
      \expandafter\getfirst@LISTB\LISTB\endparse
      \let\tmpb\tmp
      \ifnum\n<\tmpb
         \begin{scope}[thick]
           \begin{scope}[style=\s, color=\c]
             \let\tmpa\@empty
             \ifx\tprofile\@empty
               \foreach \k in {\number\n,...,\tmpb}{%
                 \expandafter\getfirst@LIST\LIST\endparse
                 \ifx\tmpa\@empty
                   \fill (\k,-\tmp) circle (1.5pt);
                 \fi
                 \xdef\tmpa{\tmpa\space(\k,-\tmp)}
                 }
             \else
               \expandafter\getfirst@LISTC\LISTC\endparse
               \edef\ctprofile{\tmp}
               \loop
                 \expandafter\getfirst@LISTC\LISTC\endparse
                 \ifnum\tmp<\tmpb
                   \xdef\ctprofile{\ctprofile,\space\tmp}%
               \repeat
               \xdef\LISTC{\tmpb\space\tmp\space\LISTC\space}
               \xdef\ctprofile{\ctprofile,\space\tmpb}
               \foreach \k in \ctprofile {%
                   \expandafter\getfirst@LIST\LIST\endparse
                   \fill (\k,-\tmp) circle (1.5pt);
                   \xdef\tmpa{\tmpa\space(\k,-\tmp)}
                 }
               \xdef\LIST{\tmp\space\LIST}
             \fi
             \draw plot coordinates{\tmpa};
           \end{scope}
         \end{scope}
         \global\n=\tmpb
         \xdef\LIST{\tmp\space\LIST\space}
      \fi
}
    \edef\LIST{\cdalarms\space}
    \expandafter\getfirst@LIST\LIST\endparse
    \alarm@count=\tmp
    \begin{scope}
      \tikzstyle{every node}=
      [chamfered rectangle,white,inner sep=0.5pt,draw]
      \foreach \k in {1,...,\alarm@count}{%
        \expandafter\getfirst@LIST\LIST\endparse
        \edef\tmpa{\tmp}
        \expandafter\getfirst@LIST\LIST\endparse
        \edef\tmpb{\tmp}
        \expandafter\getfirst@LIST\LIST\endparse
        \edef\tmpc{\tmp}
        \ifx\tmpa\ASCENT
          \fill[color=Acolor] (\tmpb,-\tmpc) circle (1.5pt);
          \draw[color=Acolor] (\tmpb,-\tmpc) -- (\tmpb,-\Yalarm);
          \node[fill=Acolor,above] at (\tmpb,-\Yalarm) {\AlarmFont A};
        \fi
        \ifx\tmpa\DECO
          \fill[color=Dcolor] (\tmpb,-\tmpc) circle (1.5pt);
          \draw[color=Dcolor] (\tmpb,-\tmpc) -- (\tmpb,-\Yalarm);
          \node[fill=Dcolor,above] at (\tmpb,-\Yalarm) {\AlarmFont D};
        \fi
        \ifx\tmpa\DEEPSTOP
          \fill[color=Dcolor] (\tmpb,-\tmpc) circle (1.5pt);
          \draw[color=Dcolor] (\tmpb,-\tmpc) -- (\tmpb,-\Yalarm);
          \node[fill=Dcolor,above] at (\tmpb,-\Yalarm) {\AlarmFont D};
        \fi
        \ifx\tmpa\ERROR
          \fill[color=Ecolor] (\tmpb,-\tmpc) circle (1.5pt);
          \draw[color=Ecolor] (\tmpb,-\tmpc) -- (\tmpb,-\Yalarm);
          \node[fill=Ecolor,above] at (\tmpb,-\Yalarm) {\AlarmFont E};
        \fi
        \ifx\tmpa\CEILING
          \fill[color=Ecolor] (\tmpb,-\tmpc) circle (1.5pt);
          \draw[color=Ecolor] (\tmpb,-\tmpc) -- (\tmpb,-\Yalarm);
          \node[fill=Ecolor,above] at (\tmpb,-\Yalarm) {\AlarmFont C};
        \fi
        \ifx\tmpa\PPOHIGH
          \fill[color=Ecolor] (\tmpb,-\tmpc) circle (1.5pt);
          \draw[color=Ecolor] (\tmpb,-\tmpc) -- (\tmpb,-\Yalarm);
          \node[fill=Ecolor,above] at (\tmpb,-\Yalarm) {\AlarmFont H};
        \fi
        \ifx\tmpa\PPOLOW
          \fill[color=Ecolor] (\tmpb,-\tmpc) circle (1.5pt);
          \draw[fill=Ecolor] (\tmpb,-\tmpc) -- (\tmpb,-\Yalarm);
          \node[fill=Ecolor,above] at (\tmpb,-\Yalarm) {\AlarmFont L};
        \fi
        \ifx\tmpa\BOOKMARK
          \fill[color=Bcolor] (\tmpb,-\tmpc) circle (1.5pt);
          \draw[color=Bcolor] (\tmpb,-\tmpc) -- (\tmpb,-\Yalarm);
          \node[fill=Bcolor,above] at (\tmpb,-\Yalarm) {\AlarmFont B};
        \fi
       }
    \end{scope}
    \edef\LISTB{\gaslist\space}%
    \expandafter\getfirst@LISTB\LISTB\endparse
    \let\tmpa\tmp
    \node (x) at (\lasttic,-\Ygs) {};
    \foreach \k in {1,...,\tmpa}{
       \expandafter\getfirst@LISTB\LISTB\endparse
       \node at (x) [color=Path\k, left] {\SwitchFont \tmp};
       \node (x) at ($(x) + (0,\Ystep)$) {};
      }
    \ifCCRmode
      \edef\LISTB{\splist\space}%
      \expandafter\getfirst@LISTB\LISTB\endparse
      \let\tmpa\tmp
      \begin{scope}[color=Path1, thick]
      \ifnum\tmpa>1
        \ifnum\tmpa=2
          \let\tmpb\SPhighStyle
        \else
          \let\tmpb\SPmedStyle
        \fi
        \expandafter\getfirst@LISTB\LISTB\endparse
        \node (x) at (\SPposX,-\Ygs) {};
        \draw[style=\SPlowStyle] (x) -- ($(x) + (-\SPwd,0)$)
                       node [left] {\SwitchFont SP\tmp};
        \expandafter\getfirst@LISTB\LISTB\endparse
        \node (x) at ($(x) + (0,\Ystep)$) {};
        \draw[style=\tmpb] (x) -- ($(x) + (-\SPwd,0)$)
                       node [left] {\SwitchFont SP\tmp};
        \ifnum\tmpa=3
          \expandafter\getfirst@LISTB\LISTB\endparse
          \node (x) at ($(x) + (0,\Ystep)$) {};
          \draw[style=\SPhighStyle] (x) -- ($(x) + (-\SPwd,0)$)
                        node [left] {\SwitchFont SP\tmp};
        \fi
      \fi
      \ifNeverBO\else
        \node (x) at ($(x) + (0,\Ystep)$) {};
        \draw[style=\BOStyle, color=\BOcolor]
                       (x) -- ($(x) + (-\SPwd,0)$)
                       node [left] {\SwitchFont Bailout};
      \fi
      \end{scope}
    \fi
    \print@user@tags
    \ifx\maxttstime\@empty
    \else
      \edef\tmpa{\maxttstime}%
      \pgfmathparse{\tmpa * 60 / \cddelta}%
      \edef\tmpa{\pgfmathresult}%
      \edef\tmpb{\maxttsdepth}%
      \fill[color=Tcolor]   (\tmpa,-\tmpb) circle (1.5pt);
      \node[below right] at (\tmpa,-\tmpb) [color=Tcolor]
           {\TTSFont TTS=\maxtts\ \minabbrev};
    \fi
  \end{tikzpicture}
  \hss}%
}
\newcommand*{\PrintGF}{%
  \pgfmathparse{\GFheight/100}%
  \edef\GFunit{\pgfmathresult}%
  \pgfmathparse{20*\GFunit}%
  \edef\GFtic{\pgfmathresult}%
  \centerline{\hss
  \begin{tikzpicture}[x=\Xunit,y=\GFunit]
    \foreach \y in {0,20,...,100}
        {\node at    (0,\y) [left] {\TimeDepthFont\y};
         \draw[gray] (0,\y) -- (\lasttic,\y);
         \node at (\lasttic,\y) [right] {\TimeDepthFont\y};
        }
    \ifnum\Xii>\lasttic
       \node at    (\Xtic,0) [below] {\TimeDepthFont \Xinc};
       \draw[gray] (\Xtic,0) -- (\Xtic,100);
    \else
      \foreach \x in {\Xtic,\Xii,...,\lasttic}
        {\pgfmathparse{int(\x / \Xscale)}
         \edef\Xinc{\pgfmathresult}
         \node at    (\x,0) [below] {\TimeDepthFont \Xinc};
         \draw[gray] (\x,0) -- (\x,100);
       }
    \fi
    \draw[gray,thick] (0,0) rectangle (\lasttic,100);
    \ifx\gfhigh\@empty
      \node at (0,90) [color=white,inner sep=.5pt,fill,right,text=black]
           {\GFFont Gradient Factors};
    \else
    \begin{scope}[color=Fcolor,
      every node/.style={color=white,inner sep=.5pt,fill,text=Fcolor}]
      \draw [thick] (0,\gflow) -- (\lasttic,\gflow);
      \node at (0,\gflow) [right] {\GFFont GFlow};
      \draw [thick] (0,\gfhigh) -- (\lasttic,\gfhigh);
      \node at    (0,\gfhigh) [right] {\GFFont GFhigh};
    \end{scope}
    \fi
    \edef\LIST{\gfprofile\space}%
    \expandafter\getfirst@LIST\LIST\endparse
    \edef\tmpa{(0,0)}
    \pgfmathparse{2*\gfstep}
    \foreach \k in {\gfstep,\pgfmathresult,...,\lasttic}{%
       \expandafter\getfirst@LIST\LIST\endparse
       \xdef\tmpa{\tmpa\space(\k,\tmp)}
      }
    \draw[thick] plot coordinates{\tmpa};
  \end{tikzpicture}
  \hss}%
}
\newenvironment{notes}
   {\textbf{\dlnotes}\par}
   {}
\ifPrivate
  \let\private\comment
  \let\endprivate\endcomment
\else
  \newenvironment{private}
    {\par}
    {}
\fi
\InputIfFileExists{logbook.cfg}
   {\typeout{Loading logbook.cfg}}
   {\typeout{No logbook.cfg file found, skipping.}}
\InputIfFileExists{aliases.tex}
   {\typeout{Loading aliases.tex}}
   {\typeout{No aliases.tex file found, skipping.}}
\endinput
%%
%% End of file `logbook.cls'.
